% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geodimension.R
\name{geodimension}
\alias{geodimension}
\title{\code{geodimension} S3 class}
\usage{
geodimension(name = NULL, level = NULL)
}
\arguments{
\item{name}{A string, name of the dimension.}

\item{level}{A \code{geolevel}.}
}
\value{
A \code{geodimension} object.
}
\description{
A \code{geodimension} object is created. A \code{geodimension} allows us to relate
levels. In addition to the name of the \code{geodimension} , a \code{level} has to be
given.
}
\examples{
region <-
  geolevel(name = "region",
           layer = layer_us_region,
           key = c("geoid"))

gd <-
  geodimension(name = "gd_us",
               level = region)

}
\seealso{
Other level association functions: 
\code{\link{add_level}()},
\code{\link{complete_relation_by_geography}()},
\code{\link{get_unrelated_instances}()},
\code{\link{relate_levels}()}
}
\concept{level association functions}
