% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simpsons.R
\name{area_above}
\alias{area_above}
\title{Area Above the Bearing Area Curve}
\usage{
area_above(f, a, b, n = 100)
}
\arguments{
\item{f}{The function for the Bearing Area curve produced by
\code{stats::ecdf()}.}

\item{a}{Numeric. The left x boundary.}

\item{b}{Numeric. The right x boundary.}

\item{n}{Numeric. The number of subdivisions along the function
line.}
}
\value{
A numeric value representing the area above the curve with
  x bounds \code{a} and \code{b}.
}
\description{
Calculates the area above the bearing area curve from
points \code{a} to \code{b}. If a box is drawn around
a function with the upper-left at \code{a} and the
bottom-right at \code{b}, this function extracts the area
above the function within the box.
}
\details{
The area under the curve used to calculate area above the
curve is calculated as the numerical integral
of the Bearing Area function from \code{a} to \code{b}
using the trapezoid rule with n subdivisions. Assume
\code{a < b} and \code{n} is a positive integer.
}
\examples{
library(raster)

# import raster image
data(normforest)

# basic values
z <- getValues(normforest)

# calculate cumulative probability density function of surface 'height' (= ndvi)
mod <- ecdf((1 - z))

# valley fluid retention index = void volume in 'valley' zone
Svi <- area_above(f = mod, b = 1, a = 0.8, n = 500)
}
