% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{sfd_}
\alias{sfd_}
\title{Calculate the fractal dimension of a raster (C function).}
\usage{
sfd_(mat)
}
\arguments{
\item{mat}{A matrix.}
}
\value{
A numeric value representing the fractal dimension of
the image.
}
\description{
Calculates the 3D fractal dimension of a raster using the
triangular prism surface area method.
}
\examples{

# import raster image
data(normforest)

# convert to matrix
mat <- raster::as.matrix(normforest)

# calculate the fractal dimension
Sfd <- sfd_(mat)
}
\references{
Clarke, K.C., 1986. Computation of the fractal dimension of topographic
surfaces using the triangular prism surface area method. Computers & Geosciences,
12(5), pp.713-722.
}
