% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acs_5yr_download.R
\name{get_area_file_names}
\alias{get_area_file_names}
\alias{get_area_file_names.acs_5yr}
\title{Get area file names}
\usage{
get_area_file_names(ac, area, years)

\method{get_area_file_names}{acs_5yr}(ac, area, years = NULL)
}
\arguments{
\item{ac}{An \code{acs_5yr} object.}

\item{area}{A string, area name.}

\item{years}{A vector, year number.}
}
\value{
A vector, file urls.
}
\description{
Get area url file names for the given years. If no year is indicated, all
available ones are obtained.
}
\examples{

dir <- system.file("extdata/acs_5yr", package = "geogenr")
ac <- acs_5yr(dir)

url <- ac |>
  get_area_file_names("State", 2019:2021)

url <- ac |>
  get_area_file_names("State")

}
\seealso{
Other data download functions: 
\code{\link{acs_5yr}()},
\code{\link{download_selected_files}()},
\code{\link{get_area_groups}()},
\code{\link{get_area_years}()},
\code{\link{get_areas}()},
\code{\link{get_selected_file_names}()},
\code{\link{get_too_heavy_file_names}()},
\code{\link{select_area_files}()},
\code{\link{unzip_files}()}
}
\concept{data download functions}
