% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02-webgeom-obj.R
\docType{methods}
\name{webgeom}
\alias{webgeom}
\alias{webgeom,missing-method}
\alias{webgeom,ANY-method}
\title{create webgeom object}
\usage{
webgeom(.Object, ...)

\S4method{webgeom}{missing}(.Object, ...)

\S4method{webgeom}{ANY}(.Object, ...)
}
\arguments{
\item{.Object}{any object that can be coerced into \linkS4class{webgeom}}

\item{\dots}{additional arguments passed initialize method (e.g., \code{\link{url}}). See 
the named slots above for arguments for \dots}
}
\value{
the webgeom object representing a dataset and parameters
}
\description{
A class representing a web available feature geometry.
}
\details{
slots can be accessed or set with methods of the same names 
(e.g., url(webgeom()))
}
\section{Slots}{

\describe{
\item{\code{url}}{value of type \code{"character"}, the web location for the web feature service}

\item{\code{geom}}{value of type \code{"character"}, the feature for webgeom}

\item{\code{attribute}}{the attribute (e.g., "State")}

\item{\code{values}}{the values of the attribute, (e.g., "Wisconsin") or NA (all)}
}}

\examples{
wg <- webgeom(geom = "sample:CONUS_states", 
 attribute = "STATE",
 values = "New Hampshire")
#-- use available state datasets:
wg <- webgeom('state::New Hampshire')
wg <- webgeom('state::New Hampshire,Wisconsin,Alabama')
#-- use available Level III Ecoregion datasets:
wg <- webgeom('ecoregion::Colorado Plateaus,Driftless Area')
#-- use available simplified HUC8s:
wg <- webgeom('HUC8::09020306,14060009')
wg <- webgeom()

\dontrun{
## Steps to find data on Howard County in Texas:
#1) locate the \\code{geom} for counties by looking at the options for geoms
query(webgeom(), 'geoms') # discover sample:Counties
#2) locate the \\code{attribute} for county names by looking at the options for attributes
query(webgeom(geom='sample:Counties'), 'attributes') # discover FIPS
#3) find the appropriate fip code for the county:
howard.fips <- maps::county.fips \%>\% 
   dplyr::filter(polyname == 'texas,howard') \%>\% .$fips \%>\% as.character
#4) create a webgeom for the Howard County in Texas
stencil <- webgeom(geom='sample:Counties', attribute='FIPS', values=howard.fips)
#5) get data for Howard County
fabric <- webdata(url = 'https://cida.usgs.gov/thredds/dodsC/stageiv_combined', 
variables = "Total_precipitation_surface_1_Hour_Accumulation", 
times = c(as.POSIXct("2016-06-06 05:00:00"), 
          as.POSIXct("2016-06-07 05:00:00")))
job <- geoknife(stencil, fabric, wait = TRUE)
precipData <- result(job)
head(precipData)
}
}
\seealso{
\code{\link{url}}, \code{\link{geom}}, \code{\link{attribute}}, \code{\link{values}}
}
\author{
Jordan S Read
}
