% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datatables.R
\name{block2prec_by_county}
\alias{block2prec_by_county}
\title{Aggregate Block Table by Matches and County}
\usage{
block2prec_by_county(block_table, precinct, precinct_county_fips)
}
\arguments{
\item{block_table}{Required. Block table output from create_block_table}

\item{precinct}{sf dataframe of shapefiles to match to.}

\item{precinct_county_fips}{Column within precincts}
}
\value{
dataframe with nrow(precinct) rows
}
\description{
Performs the same type of operation as block2prec, but subsets a precinct geometry
based on a County fips column. This helps get around the problem that county geometries
often have borders that follow rivers and lead to funny shaped blocks. This guarantees
that every block is matched to a precinct which is in the same county.
}
\examples{
\dontrun{
# Need Census API
data(towns)
towns$fips <- '087'
block <- create_block_table('NY', 'Rockland')
block2prec_by_county(block, towns, 'fips')
}
}
\concept{datatable}
