% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOImageryEvent.R
\docType{class}
\name{ISOImageryEvent}
\alias{ISOImageryEvent}
\title{ISOImageryEvent}
\format{\code{\link{R6Class}} object.}
\usage{
ISOImageryEvent
}
\value{
Object of \code{\link{R6Class}} for modelling an ISO imagery event
}
\description{
ISOImageryEvent
}
\section{Fields}{

\describe{
\item{\code{identifier}}{[\code{\link{ISOMetaIdentifier}}]}

\item{\code{trigger}}{[\code{\link{ISOImageryTrigger}}]}

\item{\code{context}}{[\code{\link{ISOImageryContext}}]}

\item{\code{sequence}}{[\code{\link{ISOImagerySequence}}]}

\item{\code{time}}{[\code{\link{POSIXt}}]}

\item{\code{relatedPass}}{[\code{\link{ISOImageryPlatformPass}}]}

\item{\code{relatedSensor}}{[\code{list} of \code{\link{ISOImageryInstrument}}]}

\item{\code{expectedObjective}}{[\code{list} of \code{\link{ISOImageryObjective}}]}
}}

\section{Methods}{

\describe{
 \item{\code{new(xml)}}{
   This method is used to instantiate an \code{\link{ISOImageryEvent}}
 }
 \item{\code{setIdentifier(identifier)}}{
   Sets an identifier, object of class \code{character} or \code{\link{ISOMetaIdentifier}}
 }
 \item{\code{setTrigger(trigger)}}{
   Set the trigger, object of class \code{\link{ISOImageryTrigger}}, or 'character' among
   values given by \code{ISOImageryTrigger$values()}, or free text.
 }
 \item{\code{setContext(context)}}{
   Set the context, object of class \code{\link{ISOImageryContext}}, or 'character' among
   values given by \code{ISOImageryContext$values()}, or free text.
 }
 \item{\code{setSequence(sequence)}}{
   Set the sequence, object of class  \code{\link{ISOImagerySequence}}, or 'character' among
   values given by \code{ISOImagerySequence$values()}, or free text.
 }
 \item{\code{setTime(time)}}{
   Set the time, object of class \code{\link{POSIXt}}.
 }
 \item{\code{setPlatformPass(platformPass)}}{
   Set the platform pass, object of class \code{\link{ISOImageryPlatformPass}}
 }
 \item{\code{addSensor(sensor)}}{
   Adds a sensor, object of class \code{\link{ISOImageryInstrument}}.
 }
 \item{\code{delSensor(sensor)}}{
   Deletes a sensor, object of class \code{\link{ISOImageryInstrument}}
 }
 \item{\code{addObjective(objective)}}{
   Adds an objective, object of class \code{\link{ISOImageryObjective}}
 }
 \item{\code{delObjective(objective)}}{
   Deletes an objective, object of class \code{\link{ISOImageryObjective}}
 }
}
}

\examples{
   md <- ISOImageryEvent$new()
   md$setIdentifier("event_1")
   md$setTrigger("manual")
   md$setContext("pass")
   md$setSequence("instantaneous")
   md$setTime(Sys.time())
 
   xml <- md$encode()

}
\references{
ISO 19115-2:2009 - Geographic information -- Metadata Part 2: Extensions for imagery and gridded data
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{event}
\keyword{imagery}
