% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOMultiplicityRange.R
\docType{class}
\name{ISOMultiplicityRange}
\alias{ISOMultiplicityRange}
\title{ISOMultiplicityRange}
\format{\code{\link{R6Class}} object.}
\usage{
ISOMultiplicityRange
}
\value{
Object of \code{\link{R6Class}} for modelling an ISO MultiplicityRange
}
\description{
ISOMultiplicityRange
}
\section{Fields}{

\describe{
\item{\code{lower}}{[\code{\link{integer}}] lower value}

\item{\code{upper}}{[\code{\link{integer}}] upper value}
}}

\section{Methods}{

\describe{
 \item{\code{new(xml, lower, upper)}}{
   This method is used to instantiate an \code{\link{ISOMultiplicityRange}}
 }
}
}

\examples{
  md <- ISOMultiplicityRange$new(lower = 1, upper = Inf)
  xml <- md$encode()

}
\references{
ISO/TS 19103:2005 Geographic information -- Conceptual schema language
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{multiplicity}
\keyword{range}
