% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOIdentification19115_3.R
\docType{class}
\name{ISOIdentification19115_3}
\alias{ISOIdentification19115_3}
\title{ISOIdentification19115_3}
\format{
\code{\link[R6]{R6Class}} object.
}
\value{
Object of \code{\link[R6]{R6Class}} for modelling an ISO Identification in ISO 19115-3
}
\description{
ISOIdentification19115_3

ISOIdentification19115_3
}
\references{
- ISO 19115-3 \url{https://schemas.isotc211.org/19115/-3/mri/1.0/mri/#element_AbstractMD_Identification}
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{identification}
\section{Super classes}{
\code{\link[geometa:geometaLogger]{geometa::geometaLogger}} -> \code{\link[geometa:ISOAbstractObject]{geometa::ISOAbstractObject}} -> \code{\link[geometa:ISOIdentification]{geometa::ISOIdentification}} -> \code{ISOIdentification19115_3}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{citation}}{citation: ISOCitation}

\item{\code{abstract}}{abstract: character}

\item{\code{purpose}}{purpose [0..1]: character}

\item{\code{credit}}{credit [0..*]: character}

\item{\code{status}}{status [0..*]: ISOProgress}

\item{\code{pointOfContact}}{pointOfContact [0..*]: ISOResponsibility}

\item{\code{spatialRepresentationType}}{spatialRepresentationType [0..*]: ISOSpatialRepresentationType}

\item{\code{spatialResolution}}{spatialResolution [0..*]: ISOResolution}

\item{\code{temporalResolution}}{[0..*]: ISOPeriodDuration}

\item{\code{topicCategory}}{topicCategory [0..*]: ISOTopicCategory}

\item{\code{extent}}{extent [0..*]: ISOExtent (ISO 19139)}

\item{\code{additionalDocumentation}}{additional documentation [0..*]: ISOCitation}

\item{\code{processingLevel}}{processing level [0..1]: ISOMetaIdentifier}

\item{\code{resourceMaintenance}}{resourceMaintenance [0..*]: ISOMaintenanceInformation}

\item{\code{graphicOverview}}{graphicOverview [0..*]: ISOBrowseGraphic}

\item{\code{resourceFormat}}{resourceFormat [0..*]: ISOFormat}

\item{\code{descriptiveKeywords}}{descriptiveKeywords [0..*]: ISOKeywords (ISO 19139)}

\item{\code{resourceSpecificUsage}}{resourceSpecificUsage [0..*]: ISOUsage (ISO 19139)}

\item{\code{resourceConstraints}}{resourceConstraints [0..*]: ISOLegalConstraints}

\item{\code{aggregationInfo}}{aggregationInfo [0..*]: ISOAggregateInformation}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ISOIdentification19115_3-new}{\code{ISOIdentification19115_3$new()}}
\item \href{#method-ISOIdentification19115_3-setCitation}{\code{ISOIdentification19115_3$setCitation()}}
\item \href{#method-ISOIdentification19115_3-setAbstract}{\code{ISOIdentification19115_3$setAbstract()}}
\item \href{#method-ISOIdentification19115_3-setPurpose}{\code{ISOIdentification19115_3$setPurpose()}}
\item \href{#method-ISOIdentification19115_3-addCredit}{\code{ISOIdentification19115_3$addCredit()}}
\item \href{#method-ISOIdentification19115_3-delCredit}{\code{ISOIdentification19115_3$delCredit()}}
\item \href{#method-ISOIdentification19115_3-addStatus}{\code{ISOIdentification19115_3$addStatus()}}
\item \href{#method-ISOIdentification19115_3-delStatus}{\code{ISOIdentification19115_3$delStatus()}}
\item \href{#method-ISOIdentification19115_3-addPointOfContact}{\code{ISOIdentification19115_3$addPointOfContact()}}
\item \href{#method-ISOIdentification19115_3-delPointOfContact}{\code{ISOIdentification19115_3$delPointOfContact()}}
\item \href{#method-ISOIdentification19115_3-addSpatialRepresentationType}{\code{ISOIdentification19115_3$addSpatialRepresentationType()}}
\item \href{#method-ISOIdentification19115_3-delSpatialRepresentationType}{\code{ISOIdentification19115_3$delSpatialRepresentationType()}}
\item \href{#method-ISOIdentification19115_3-addSpatialResolution}{\code{ISOIdentification19115_3$addSpatialResolution()}}
\item \href{#method-ISOIdentification19115_3-delSpatialResolution}{\code{ISOIdentification19115_3$delSpatialResolution()}}
\item \href{#method-ISOIdentification19115_3-addTemporalResolution}{\code{ISOIdentification19115_3$addTemporalResolution()}}
\item \href{#method-ISOIdentification19115_3-delTemporalResolution}{\code{ISOIdentification19115_3$delTemporalResolution()}}
\item \href{#method-ISOIdentification19115_3-addTopicCategory}{\code{ISOIdentification19115_3$addTopicCategory()}}
\item \href{#method-ISOIdentification19115_3-delTopicCategory}{\code{ISOIdentification19115_3$delTopicCategory()}}
\item \href{#method-ISOIdentification19115_3-addExtent}{\code{ISOIdentification19115_3$addExtent()}}
\item \href{#method-ISOIdentification19115_3-delExtent}{\code{ISOIdentification19115_3$delExtent()}}
\item \href{#method-ISOIdentification19115_3-addAdditionalDocumentation}{\code{ISOIdentification19115_3$addAdditionalDocumentation()}}
\item \href{#method-ISOIdentification19115_3-delAdditionalDocumentation}{\code{ISOIdentification19115_3$delAdditionalDocumentation()}}
\item \href{#method-ISOIdentification19115_3-setProcessingLevel}{\code{ISOIdentification19115_3$setProcessingLevel()}}
\item \href{#method-ISOIdentification19115_3-addResourceMaintenance}{\code{ISOIdentification19115_3$addResourceMaintenance()}}
\item \href{#method-ISOIdentification19115_3-delResourceMaintenance}{\code{ISOIdentification19115_3$delResourceMaintenance()}}
\item \href{#method-ISOIdentification19115_3-addGraphicOverview}{\code{ISOIdentification19115_3$addGraphicOverview()}}
\item \href{#method-ISOIdentification19115_3-delGraphicOverview}{\code{ISOIdentification19115_3$delGraphicOverview()}}
\item \href{#method-ISOIdentification19115_3-addFormat}{\code{ISOIdentification19115_3$addFormat()}}
\item \href{#method-ISOIdentification19115_3-delFormat}{\code{ISOIdentification19115_3$delFormat()}}
\item \href{#method-ISOIdentification19115_3-addKeywords}{\code{ISOIdentification19115_3$addKeywords()}}
\item \href{#method-ISOIdentification19115_3-delKeywords}{\code{ISOIdentification19115_3$delKeywords()}}
\item \href{#method-ISOIdentification19115_3-addResourceSpecificUsage}{\code{ISOIdentification19115_3$addResourceSpecificUsage()}}
\item \href{#method-ISOIdentification19115_3-delResourceSpecificUsage}{\code{ISOIdentification19115_3$delResourceSpecificUsage()}}
\item \href{#method-ISOIdentification19115_3-addResourceConstraints}{\code{ISOIdentification19115_3$addResourceConstraints()}}
\item \href{#method-ISOIdentification19115_3-delResourceConstraints}{\code{ISOIdentification19115_3$delResourceConstraints()}}
\item \href{#method-ISOIdentification19115_3-addAssociatedResource}{\code{ISOIdentification19115_3$addAssociatedResource()}}
\item \href{#method-ISOIdentification19115_3-delAssociatedResource}{\code{ISOIdentification19115_3$delAssociatedResource()}}
\item \href{#method-ISOIdentification19115_3-clone}{\code{ISOIdentification19115_3$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="geometa" data-topic="geometaLogger" data-id="ERROR"><a href='../../geometa/html/geometaLogger.html#method-geometaLogger-ERROR'><code>geometa::geometaLogger$ERROR()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="geometaLogger" data-id="INFO"><a href='../../geometa/html/geometaLogger.html#method-geometaLogger-INFO'><code>geometa::geometaLogger$INFO()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="geometaLogger" data-id="WARN"><a href='../../geometa/html/geometaLogger.html#method-geometaLogger-WARN'><code>geometa::geometaLogger$WARN()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="addFieldAttrs"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-addFieldAttrs'><code>geometa::ISOAbstractObject$addFieldAttrs()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="addListElement"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-addListElement'><code>geometa::ISOAbstractObject$addListElement()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="checkMetadataStandardCompliance"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-checkMetadataStandardCompliance'><code>geometa::ISOAbstractObject$checkMetadataStandardCompliance()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="contains"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-contains'><code>geometa::ISOAbstractObject$contains()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="createLocalisedProperty"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-createLocalisedProperty'><code>geometa::ISOAbstractObject$createLocalisedProperty()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="decode"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-decode'><code>geometa::ISOAbstractObject$decode()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="delListElement"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-delListElement'><code>geometa::ISOAbstractObject$delListElement()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="encode"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-encode'><code>geometa::ISOAbstractObject$encode()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="getClass"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-getClass'><code>geometa::ISOAbstractObject$getClass()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="getClassName"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-getClassName'><code>geometa::ISOAbstractObject$getClassName()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="getNamespaceDefinition"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-getNamespaceDefinition'><code>geometa::ISOAbstractObject$getNamespaceDefinition()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="isDocument"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-isDocument'><code>geometa::ISOAbstractObject$isDocument()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="isFieldInheritedFrom"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-isFieldInheritedFrom'><code>geometa::ISOAbstractObject$isFieldInheritedFrom()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="print"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-print'><code>geometa::ISOAbstractObject$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="save"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-save'><code>geometa::ISOAbstractObject$save()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setAttr"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setAttr'><code>geometa::ISOAbstractObject$setAttr()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setCodeList"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setCodeList'><code>geometa::ISOAbstractObject$setCodeList()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setCodeListValue"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setCodeListValue'><code>geometa::ISOAbstractObject$setCodeListValue()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setCodeSpace"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setCodeSpace'><code>geometa::ISOAbstractObject$setCodeSpace()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setHref"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setHref'><code>geometa::ISOAbstractObject$setHref()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setId"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setId'><code>geometa::ISOAbstractObject$setId()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setIsNull"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setIsNull'><code>geometa::ISOAbstractObject$setIsNull()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setValue"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setValue'><code>geometa::ISOAbstractObject$setValue()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="stopIfMetadataStandardIsNot"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-stopIfMetadataStandardIsNot'><code>geometa::ISOAbstractObject$stopIfMetadataStandardIsNot()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="validate"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-validate'><code>geometa::ISOAbstractObject$validate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="wrapBaseElement"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-wrapBaseElement'><code>geometa::ISOAbstractObject$wrapBaseElement()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOIdentification19115_3-new"></a>}}
\if{latex}{\out{\hypertarget{method-ISOIdentification19115_3-new}{}}}
\subsection{Method \code{new()}}{
Initializes object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOIdentification19115_3$new(xml = NULL, defaults = list())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xml}}{object of class \link[XML]{XMLInternalNode-class}}

\item{\code{defaults}}{defaults list}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOIdentification19115_3-setCitation"></a>}}
\if{latex}{\out{\hypertarget{method-ISOIdentification19115_3-setCitation}{}}}
\subsection{Method \code{setCitation()}}{
Set citation
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOIdentification19115_3$setCitation(citation)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{citation}}{object of class \link{ISOCitation}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOIdentification19115_3-setAbstract"></a>}}
\if{latex}{\out{\hypertarget{method-ISOIdentification19115_3-setAbstract}{}}}
\subsection{Method \code{setAbstract()}}{
Set abstract
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOIdentification19115_3$setAbstract(abstract, locales = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{abstract}}{abstract}

\item{\code{locales}}{list of localized abstracts. Default is \code{NULL}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOIdentification19115_3-setPurpose"></a>}}
\if{latex}{\out{\hypertarget{method-ISOIdentification19115_3-setPurpose}{}}}
\subsection{Method \code{setPurpose()}}{
Set purpose
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOIdentification19115_3$setPurpose(purpose, locales = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{purpose}}{purpose}

\item{\code{locales}}{list of localized texts. Default is \code{NULL}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOIdentification19115_3-addCredit"></a>}}
\if{latex}{\out{\hypertarget{method-ISOIdentification19115_3-addCredit}{}}}
\subsection{Method \code{addCredit()}}{
Adds credit
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOIdentification19115_3$addCredit(credit, locales = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{credit}}{credit}

\item{\code{locales}}{list of localized texts. Default is \code{NULL}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOIdentification19115_3-delCredit"></a>}}
\if{latex}{\out{\hypertarget{method-ISOIdentification19115_3-delCredit}{}}}
\subsection{Method \code{delCredit()}}{
Deletes credit
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOIdentification19115_3$delCredit(credit, locales = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{credit}}{credit}

\item{\code{locales}}{list of localized texts. Default is \code{NULL}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOIdentification19115_3-addStatus"></a>}}
\if{latex}{\out{\hypertarget{method-ISOIdentification19115_3-addStatus}{}}}
\subsection{Method \code{addStatus()}}{
Adds status
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOIdentification19115_3$addStatus(status)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{status}}{object of class \link{ISOProgress} or any \link{character} among
values returned by \code{ISOProgress$values()}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOIdentification19115_3-delStatus"></a>}}
\if{latex}{\out{\hypertarget{method-ISOIdentification19115_3-delStatus}{}}}
\subsection{Method \code{delStatus()}}{
Deletes status
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOIdentification19115_3$delStatus(status)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{status}}{object of class \link{ISOProgress} or any \link{character} among
values returned by \code{ISOProgress$values()}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOIdentification19115_3-addPointOfContact"></a>}}
\if{latex}{\out{\hypertarget{method-ISOIdentification19115_3-addPointOfContact}{}}}
\subsection{Method \code{addPointOfContact()}}{
Adds point of contact
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOIdentification19115_3$addPointOfContact(pointOfContact)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{pointOfContact}}{object of class \link{ISOResponsibility}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOIdentification19115_3-delPointOfContact"></a>}}
\if{latex}{\out{\hypertarget{method-ISOIdentification19115_3-delPointOfContact}{}}}
\subsection{Method \code{delPointOfContact()}}{
Deletes point of contact
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOIdentification19115_3$delPointOfContact(pointOfContact)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{pointOfContact}}{object of class \link{ISOResponsibility}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOIdentification19115_3-addSpatialRepresentationType"></a>}}
\if{latex}{\out{\hypertarget{method-ISOIdentification19115_3-addSpatialRepresentationType}{}}}
\subsection{Method \code{addSpatialRepresentationType()}}{
Adds spatial representation type
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOIdentification19115_3$addSpatialRepresentationType(
  spatialRepresentationType
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{spatialRepresentationType}}{object of class \link{ISOSpatialRepresentationType} or
any \link{character} among values returned by \code{ISOSpatialRepresentationType$values()}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOIdentification19115_3-delSpatialRepresentationType"></a>}}
\if{latex}{\out{\hypertarget{method-ISOIdentification19115_3-delSpatialRepresentationType}{}}}
\subsection{Method \code{delSpatialRepresentationType()}}{
Deletes spatial representation type
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOIdentification19115_3$delSpatialRepresentationType(
  spatialRepresentationType
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{spatialRepresentationType}}{object of class \link{ISOSpatialRepresentationType} or
any \link{character} among values returned by \code{ISOSpatialRepresentationType$values()}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOIdentification19115_3-addSpatialResolution"></a>}}
\if{latex}{\out{\hypertarget{method-ISOIdentification19115_3-addSpatialResolution}{}}}
\subsection{Method \code{addSpatialResolution()}}{
Adds spatial resolution
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOIdentification19115_3$addSpatialResolution(resolution)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{resolution}}{object of class \link{ISOResolution} or \link{character}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOIdentification19115_3-delSpatialResolution"></a>}}
\if{latex}{\out{\hypertarget{method-ISOIdentification19115_3-delSpatialResolution}{}}}
\subsection{Method \code{delSpatialResolution()}}{
Deletes spatial resolution
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOIdentification19115_3$delSpatialResolution(resolution)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{resolution}}{object of class \link{ISOResolution} or \link{character}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOIdentification19115_3-addTemporalResolution"></a>}}
\if{latex}{\out{\hypertarget{method-ISOIdentification19115_3-addTemporalResolution}{}}}
\subsection{Method \code{addTemporalResolution()}}{
Adds temporal resolution
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOIdentification19115_3$addTemporalResolution(resolution)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{resolution}}{object of class \link{ISOPeriodDuration} or \link{character}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOIdentification19115_3-delTemporalResolution"></a>}}
\if{latex}{\out{\hypertarget{method-ISOIdentification19115_3-delTemporalResolution}{}}}
\subsection{Method \code{delTemporalResolution()}}{
Deletes temporal resolution
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOIdentification19115_3$delTemporalResolution(resolution)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{resolution}}{object of class \link{ISOPeriodDuration} or \link{character}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOIdentification19115_3-addTopicCategory"></a>}}
\if{latex}{\out{\hypertarget{method-ISOIdentification19115_3-addTopicCategory}{}}}
\subsection{Method \code{addTopicCategory()}}{
Adds topic category
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOIdentification19115_3$addTopicCategory(topicCategory)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{topicCategory}}{object of class \link{ISOTopicCategory} or any \link{character}
value among those returned by \code{ISOTopicCategory$values()}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOIdentification19115_3-delTopicCategory"></a>}}
\if{latex}{\out{\hypertarget{method-ISOIdentification19115_3-delTopicCategory}{}}}
\subsection{Method \code{delTopicCategory()}}{
Deletes topic category
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOIdentification19115_3$delTopicCategory(topicCategory)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{topicCategory}}{object of class \link{ISOTopicCategory} or any \link{character}
value among those returned by \code{ISOTopicCategory$values()}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOIdentification19115_3-addExtent"></a>}}
\if{latex}{\out{\hypertarget{method-ISOIdentification19115_3-addExtent}{}}}
\subsection{Method \code{addExtent()}}{
Adds extent
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOIdentification19115_3$addExtent(extent)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{extent}}{object of class \link{ISOExtent}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOIdentification19115_3-delExtent"></a>}}
\if{latex}{\out{\hypertarget{method-ISOIdentification19115_3-delExtent}{}}}
\subsection{Method \code{delExtent()}}{
Deletes extent
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOIdentification19115_3$delExtent(extent)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{extent}}{object of class \link{ISOExtent}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOIdentification19115_3-addAdditionalDocumentation"></a>}}
\if{latex}{\out{\hypertarget{method-ISOIdentification19115_3-addAdditionalDocumentation}{}}}
\subsection{Method \code{addAdditionalDocumentation()}}{
Adds additional documentation
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOIdentification19115_3$addAdditionalDocumentation(additionalDocumentation)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{additionalDocumentation}}{object of class \link{ISOCitation}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOIdentification19115_3-delAdditionalDocumentation"></a>}}
\if{latex}{\out{\hypertarget{method-ISOIdentification19115_3-delAdditionalDocumentation}{}}}
\subsection{Method \code{delAdditionalDocumentation()}}{
Deletes additional documentation
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOIdentification19115_3$delAdditionalDocumentation(additionalDocumentation)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{additionalDocumentation}}{object of class \link{ISOCitation}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOIdentification19115_3-setProcessingLevel"></a>}}
\if{latex}{\out{\hypertarget{method-ISOIdentification19115_3-setProcessingLevel}{}}}
\subsection{Method \code{setProcessingLevel()}}{
Set processing level
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOIdentification19115_3$setProcessingLevel(processingLevel)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{processingLevel}}{object of class \link{ISOMetaIdentifier} or \link{character}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOIdentification19115_3-addResourceMaintenance"></a>}}
\if{latex}{\out{\hypertarget{method-ISOIdentification19115_3-addResourceMaintenance}{}}}
\subsection{Method \code{addResourceMaintenance()}}{
Adds resource maintenance
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOIdentification19115_3$addResourceMaintenance(resourceMaintenance)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{resourceMaintenance}}{object of class \link{ISOMaintenanceInformation}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOIdentification19115_3-delResourceMaintenance"></a>}}
\if{latex}{\out{\hypertarget{method-ISOIdentification19115_3-delResourceMaintenance}{}}}
\subsection{Method \code{delResourceMaintenance()}}{
Deletes resource maintenance
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOIdentification19115_3$delResourceMaintenance(resourceMaintenance)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{resourceMaintenance}}{object of class \link{ISOMaintenanceInformation}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOIdentification19115_3-addGraphicOverview"></a>}}
\if{latex}{\out{\hypertarget{method-ISOIdentification19115_3-addGraphicOverview}{}}}
\subsection{Method \code{addGraphicOverview()}}{
Adds graphic overview
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOIdentification19115_3$addGraphicOverview(graphicOverview)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{graphicOverview}}{object of class \link{ISOBrowseGraphic}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOIdentification19115_3-delGraphicOverview"></a>}}
\if{latex}{\out{\hypertarget{method-ISOIdentification19115_3-delGraphicOverview}{}}}
\subsection{Method \code{delGraphicOverview()}}{
Deletes graphic overview
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOIdentification19115_3$delGraphicOverview(graphicOverview)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{graphicOverview}}{object of class \link{ISOBrowseGraphic}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOIdentification19115_3-addFormat"></a>}}
\if{latex}{\out{\hypertarget{method-ISOIdentification19115_3-addFormat}{}}}
\subsection{Method \code{addFormat()}}{
Adds format
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOIdentification19115_3$addFormat(format)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{format}}{object of class \link{ISOFormat}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOIdentification19115_3-delFormat"></a>}}
\if{latex}{\out{\hypertarget{method-ISOIdentification19115_3-delFormat}{}}}
\subsection{Method \code{delFormat()}}{
Deletes format
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOIdentification19115_3$delFormat(format)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{format}}{object of class \link{ISOFormat}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOIdentification19115_3-addKeywords"></a>}}
\if{latex}{\out{\hypertarget{method-ISOIdentification19115_3-addKeywords}{}}}
\subsection{Method \code{addKeywords()}}{
Adds keywords
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOIdentification19115_3$addKeywords(keywords)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{keywords}}{object of class \link{ISOKeywords}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOIdentification19115_3-delKeywords"></a>}}
\if{latex}{\out{\hypertarget{method-ISOIdentification19115_3-delKeywords}{}}}
\subsection{Method \code{delKeywords()}}{
Deletes keywords
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOIdentification19115_3$delKeywords(keywords)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{keywords}}{object of class \link{ISOKeywords}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOIdentification19115_3-addResourceSpecificUsage"></a>}}
\if{latex}{\out{\hypertarget{method-ISOIdentification19115_3-addResourceSpecificUsage}{}}}
\subsection{Method \code{addResourceSpecificUsage()}}{
Adds resource specific usage
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOIdentification19115_3$addResourceSpecificUsage(usage)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{usage}}{object of class \link{ISOUsage}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOIdentification19115_3-delResourceSpecificUsage"></a>}}
\if{latex}{\out{\hypertarget{method-ISOIdentification19115_3-delResourceSpecificUsage}{}}}
\subsection{Method \code{delResourceSpecificUsage()}}{
Deletes resource specific usage
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOIdentification19115_3$delResourceSpecificUsage(usage)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{usage}}{object of class \link{ISOUsage}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOIdentification19115_3-addResourceConstraints"></a>}}
\if{latex}{\out{\hypertarget{method-ISOIdentification19115_3-addResourceConstraints}{}}}
\subsection{Method \code{addResourceConstraints()}}{
Adds resource constraints
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOIdentification19115_3$addResourceConstraints(resourceConstraints)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{resourceConstraints}}{object of class \link{ISOConstraints}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOIdentification19115_3-delResourceConstraints"></a>}}
\if{latex}{\out{\hypertarget{method-ISOIdentification19115_3-delResourceConstraints}{}}}
\subsection{Method \code{delResourceConstraints()}}{
Deletes resource constraints
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOIdentification19115_3$delResourceConstraints(resourceConstraints)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{resourceConstraints}}{object of class \link{ISOConstraints}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOIdentification19115_3-addAssociatedResource"></a>}}
\if{latex}{\out{\hypertarget{method-ISOIdentification19115_3-addAssociatedResource}{}}}
\subsection{Method \code{addAssociatedResource()}}{
Adds associated resource
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOIdentification19115_3$addAssociatedResource(associatedResource)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{associatedResource}}{object of class \link{ISOAssociatedResource}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOIdentification19115_3-delAssociatedResource"></a>}}
\if{latex}{\out{\hypertarget{method-ISOIdentification19115_3-delAssociatedResource}{}}}
\subsection{Method \code{delAssociatedResource()}}{
Deletes associated resource
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOIdentification19115_3$delAssociatedResource(associatedResource)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{associatedResource}}{object of class \link{ISOAssociatedResource}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOIdentification19115_3-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ISOIdentification19115_3-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOIdentification19115_3$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
