% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOIdentification19139.R
\docType{class}
\name{ISOIdentification19139}
\alias{ISOIdentification19139}
\title{ISOIdentification19139}
\format{
\code{\link[R6]{R6Class}} object.
}
\value{
Object of \code{\link[R6]{R6Class}} for modelling an ISO Identification in ISO 19139
}
\description{
ISOIdentification19139

ISOIdentification19139
}
\references{
- ISO 19139 \url{https://schemas.isotc211.org/19139/-/gmd/1.0/gmd/#element_AbstractMD_Identification}
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{identification}
\section{Super classes}{
\code{\link[geometa:geometaLogger]{geometa::geometaLogger}} -> \code{\link[geometa:ISOAbstractObject]{geometa::ISOAbstractObject}} -> \code{\link[geometa:ISOIdentification]{geometa::ISOIdentification}} -> \code{ISOIdentification19139}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{citation}}{citation: ISOCitation}

\item{\code{abstract}}{abstract: character}

\item{\code{purpose}}{purpose [0..1]: character}

\item{\code{credit}}{credit [0..*]: character}

\item{\code{status}}{status [0..*]: ISOProgress}

\item{\code{pointOfContact}}{pointOfContact [0..*]: ISOResponsibleParty}

\item{\code{resourceMaintenance}}{resourceMaintenance [0..*]: ISOMaintenanceInformation}

\item{\code{graphicOverview}}{graphicOverview [0..*]: ISOBrowseGraphic}

\item{\code{resourceFormat}}{resourceFormat [0..*]: ISOFormat}

\item{\code{descriptiveKeywords}}{descriptiveKeywords [0..*]: ISOKeywords}

\item{\code{resourceSpecificUsage}}{resourceSpecificUsage [0..*]: ISOUsage}

\item{\code{resourceConstraints}}{resourceConstraints [0..*]: ISOLegalConstraints}

\item{\code{aggregationInfo}}{aggregationInfo [0..*]: ISOAggregateInformation}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ISOIdentification19139-new}{\code{ISOIdentification19139$new()}}
\item \href{#method-ISOIdentification19139-setCitation}{\code{ISOIdentification19139$setCitation()}}
\item \href{#method-ISOIdentification19139-setAbstract}{\code{ISOIdentification19139$setAbstract()}}
\item \href{#method-ISOIdentification19139-setPurpose}{\code{ISOIdentification19139$setPurpose()}}
\item \href{#method-ISOIdentification19139-addCredit}{\code{ISOIdentification19139$addCredit()}}
\item \href{#method-ISOIdentification19139-delCredit}{\code{ISOIdentification19139$delCredit()}}
\item \href{#method-ISOIdentification19139-addStatus}{\code{ISOIdentification19139$addStatus()}}
\item \href{#method-ISOIdentification19139-delStatus}{\code{ISOIdentification19139$delStatus()}}
\item \href{#method-ISOIdentification19139-addPointOfContact}{\code{ISOIdentification19139$addPointOfContact()}}
\item \href{#method-ISOIdentification19139-delPointOfContact}{\code{ISOIdentification19139$delPointOfContact()}}
\item \href{#method-ISOIdentification19139-addResourceMaintenance}{\code{ISOIdentification19139$addResourceMaintenance()}}
\item \href{#method-ISOIdentification19139-setResourceMaintenance}{\code{ISOIdentification19139$setResourceMaintenance()}}
\item \href{#method-ISOIdentification19139-delResourceMaintenance}{\code{ISOIdentification19139$delResourceMaintenance()}}
\item \href{#method-ISOIdentification19139-addGraphicOverview}{\code{ISOIdentification19139$addGraphicOverview()}}
\item \href{#method-ISOIdentification19139-setGraphicOverview}{\code{ISOIdentification19139$setGraphicOverview()}}
\item \href{#method-ISOIdentification19139-delGraphicOverview}{\code{ISOIdentification19139$delGraphicOverview()}}
\item \href{#method-ISOIdentification19139-addFormat}{\code{ISOIdentification19139$addFormat()}}
\item \href{#method-ISOIdentification19139-delFormat}{\code{ISOIdentification19139$delFormat()}}
\item \href{#method-ISOIdentification19139-addKeywords}{\code{ISOIdentification19139$addKeywords()}}
\item \href{#method-ISOIdentification19139-setKeywords}{\code{ISOIdentification19139$setKeywords()}}
\item \href{#method-ISOIdentification19139-delKeywords}{\code{ISOIdentification19139$delKeywords()}}
\item \href{#method-ISOIdentification19139-addResourceConstraints}{\code{ISOIdentification19139$addResourceConstraints()}}
\item \href{#method-ISOIdentification19139-delResourceConstraints}{\code{ISOIdentification19139$delResourceConstraints()}}
\item \href{#method-ISOIdentification19139-addResourceSpecificUsage}{\code{ISOIdentification19139$addResourceSpecificUsage()}}
\item \href{#method-ISOIdentification19139-delResourceSpecificUsage}{\code{ISOIdentification19139$delResourceSpecificUsage()}}
\item \href{#method-ISOIdentification19139-addAggregateInformation}{\code{ISOIdentification19139$addAggregateInformation()}}
\item \href{#method-ISOIdentification19139-delAggregateInformation}{\code{ISOIdentification19139$delAggregateInformation()}}
\item \href{#method-ISOIdentification19139-clone}{\code{ISOIdentification19139$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="geometa" data-topic="geometaLogger" data-id="ERROR"><a href='../../geometa/html/geometaLogger.html#method-geometaLogger-ERROR'><code>geometa::geometaLogger$ERROR()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="geometaLogger" data-id="INFO"><a href='../../geometa/html/geometaLogger.html#method-geometaLogger-INFO'><code>geometa::geometaLogger$INFO()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="geometaLogger" data-id="WARN"><a href='../../geometa/html/geometaLogger.html#method-geometaLogger-WARN'><code>geometa::geometaLogger$WARN()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="addFieldAttrs"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-addFieldAttrs'><code>geometa::ISOAbstractObject$addFieldAttrs()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="addListElement"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-addListElement'><code>geometa::ISOAbstractObject$addListElement()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="checkMetadataStandardCompliance"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-checkMetadataStandardCompliance'><code>geometa::ISOAbstractObject$checkMetadataStandardCompliance()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="contains"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-contains'><code>geometa::ISOAbstractObject$contains()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="createLocalisedProperty"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-createLocalisedProperty'><code>geometa::ISOAbstractObject$createLocalisedProperty()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="decode"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-decode'><code>geometa::ISOAbstractObject$decode()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="delListElement"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-delListElement'><code>geometa::ISOAbstractObject$delListElement()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="encode"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-encode'><code>geometa::ISOAbstractObject$encode()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="getClass"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-getClass'><code>geometa::ISOAbstractObject$getClass()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="getClassName"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-getClassName'><code>geometa::ISOAbstractObject$getClassName()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="getNamespaceDefinition"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-getNamespaceDefinition'><code>geometa::ISOAbstractObject$getNamespaceDefinition()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="isDocument"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-isDocument'><code>geometa::ISOAbstractObject$isDocument()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="isFieldInheritedFrom"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-isFieldInheritedFrom'><code>geometa::ISOAbstractObject$isFieldInheritedFrom()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="print"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-print'><code>geometa::ISOAbstractObject$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="save"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-save'><code>geometa::ISOAbstractObject$save()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setAttr"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setAttr'><code>geometa::ISOAbstractObject$setAttr()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setCodeList"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setCodeList'><code>geometa::ISOAbstractObject$setCodeList()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setCodeListValue"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setCodeListValue'><code>geometa::ISOAbstractObject$setCodeListValue()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setCodeSpace"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setCodeSpace'><code>geometa::ISOAbstractObject$setCodeSpace()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setHref"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setHref'><code>geometa::ISOAbstractObject$setHref()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setId"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setId'><code>geometa::ISOAbstractObject$setId()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setIsNull"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setIsNull'><code>geometa::ISOAbstractObject$setIsNull()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setValue"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setValue'><code>geometa::ISOAbstractObject$setValue()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="stopIfMetadataStandardIsNot"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-stopIfMetadataStandardIsNot'><code>geometa::ISOAbstractObject$stopIfMetadataStandardIsNot()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="validate"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-validate'><code>geometa::ISOAbstractObject$validate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="wrapBaseElement"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-wrapBaseElement'><code>geometa::ISOAbstractObject$wrapBaseElement()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOIdentification19139-new"></a>}}
\if{latex}{\out{\hypertarget{method-ISOIdentification19139-new}{}}}
\subsection{Method \code{new()}}{
Initializes object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOIdentification19139$new(xml = NULL, defaults = list())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xml}}{object of class \link[XML]{XMLInternalNode-class}}

\item{\code{defaults}}{defaults list}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOIdentification19139-setCitation"></a>}}
\if{latex}{\out{\hypertarget{method-ISOIdentification19139-setCitation}{}}}
\subsection{Method \code{setCitation()}}{
Set citation
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOIdentification19139$setCitation(citation)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{citation}}{object of class \link{ISOCitation}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOIdentification19139-setAbstract"></a>}}
\if{latex}{\out{\hypertarget{method-ISOIdentification19139-setAbstract}{}}}
\subsection{Method \code{setAbstract()}}{
Set abstract
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOIdentification19139$setAbstract(abstract, locales = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{abstract}}{abstract}

\item{\code{locales}}{list of localized abstracts. Default is \code{NULL}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOIdentification19139-setPurpose"></a>}}
\if{latex}{\out{\hypertarget{method-ISOIdentification19139-setPurpose}{}}}
\subsection{Method \code{setPurpose()}}{
Set purpose
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOIdentification19139$setPurpose(purpose, locales = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{purpose}}{purpose}

\item{\code{locales}}{list of localized texts. Default is \code{NULL}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOIdentification19139-addCredit"></a>}}
\if{latex}{\out{\hypertarget{method-ISOIdentification19139-addCredit}{}}}
\subsection{Method \code{addCredit()}}{
Adds credit
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOIdentification19139$addCredit(credit, locales = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{credit}}{credit}

\item{\code{locales}}{list of localized texts. Default is \code{NULL}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOIdentification19139-delCredit"></a>}}
\if{latex}{\out{\hypertarget{method-ISOIdentification19139-delCredit}{}}}
\subsection{Method \code{delCredit()}}{
Deletes credit
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOIdentification19139$delCredit(credit, locales = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{credit}}{credit}

\item{\code{locales}}{list of localized texts. Default is \code{NULL}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOIdentification19139-addStatus"></a>}}
\if{latex}{\out{\hypertarget{method-ISOIdentification19139-addStatus}{}}}
\subsection{Method \code{addStatus()}}{
Adds status
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOIdentification19139$addStatus(status)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{status}}{object of class \link{ISOProgress} or any \link{character} among
values returned by \code{ISOProgress$values()}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOIdentification19139-delStatus"></a>}}
\if{latex}{\out{\hypertarget{method-ISOIdentification19139-delStatus}{}}}
\subsection{Method \code{delStatus()}}{
Deletes status
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOIdentification19139$delStatus(status)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{status}}{object of class \link{ISOProgress} or any \link{character} among
values returned by \code{ISOProgress$values()}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOIdentification19139-addPointOfContact"></a>}}
\if{latex}{\out{\hypertarget{method-ISOIdentification19139-addPointOfContact}{}}}
\subsection{Method \code{addPointOfContact()}}{
Adds point of contact
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOIdentification19139$addPointOfContact(pointOfContact)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{pointOfContact}}{object of class \link{ISOResponsibleParty}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOIdentification19139-delPointOfContact"></a>}}
\if{latex}{\out{\hypertarget{method-ISOIdentification19139-delPointOfContact}{}}}
\subsection{Method \code{delPointOfContact()}}{
Deletes point of contact
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOIdentification19139$delPointOfContact(pointOfContact)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{pointOfContact}}{object of class \link{ISOResponsibleParty}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOIdentification19139-addResourceMaintenance"></a>}}
\if{latex}{\out{\hypertarget{method-ISOIdentification19139-addResourceMaintenance}{}}}
\subsection{Method \code{addResourceMaintenance()}}{
Adds resource maintenance
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOIdentification19139$addResourceMaintenance(resourceMaintenance)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{resourceMaintenance}}{object of class \link{ISOMaintenanceInformation}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOIdentification19139-setResourceMaintenance"></a>}}
\if{latex}{\out{\hypertarget{method-ISOIdentification19139-setResourceMaintenance}{}}}
\subsection{Method \code{setResourceMaintenance()}}{
Set resource maintenance
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOIdentification19139$setResourceMaintenance(resourceMaintenance)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{resourceMaintenance}}{object of class \link{ISOMaintenanceInformation}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if set, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOIdentification19139-delResourceMaintenance"></a>}}
\if{latex}{\out{\hypertarget{method-ISOIdentification19139-delResourceMaintenance}{}}}
\subsection{Method \code{delResourceMaintenance()}}{
Deletes resource maintenance
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOIdentification19139$delResourceMaintenance(resourceMaintenance)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{resourceMaintenance}}{object of class \link{ISOMaintenanceInformation}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOIdentification19139-addGraphicOverview"></a>}}
\if{latex}{\out{\hypertarget{method-ISOIdentification19139-addGraphicOverview}{}}}
\subsection{Method \code{addGraphicOverview()}}{
Adds graphic overview
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOIdentification19139$addGraphicOverview(graphicOverview)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{graphicOverview}}{object of class \link{ISOBrowseGraphic}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOIdentification19139-setGraphicOverview"></a>}}
\if{latex}{\out{\hypertarget{method-ISOIdentification19139-setGraphicOverview}{}}}
\subsection{Method \code{setGraphicOverview()}}{
Sets graphic overview
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOIdentification19139$setGraphicOverview(graphicOverview)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{graphicOverview}}{object of class \link{ISOBrowseGraphic}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if set, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOIdentification19139-delGraphicOverview"></a>}}
\if{latex}{\out{\hypertarget{method-ISOIdentification19139-delGraphicOverview}{}}}
\subsection{Method \code{delGraphicOverview()}}{
Deletes graphic overview
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOIdentification19139$delGraphicOverview(graphicOverview)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{graphicOverview}}{object of class \link{ISOBrowseGraphic}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOIdentification19139-addFormat"></a>}}
\if{latex}{\out{\hypertarget{method-ISOIdentification19139-addFormat}{}}}
\subsection{Method \code{addFormat()}}{
Adds format
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOIdentification19139$addFormat(format)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{format}}{object of class \link{ISOFormat}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOIdentification19139-delFormat"></a>}}
\if{latex}{\out{\hypertarget{method-ISOIdentification19139-delFormat}{}}}
\subsection{Method \code{delFormat()}}{
Deletes format
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOIdentification19139$delFormat(format)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{format}}{object of class \link{ISOFormat}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOIdentification19139-addKeywords"></a>}}
\if{latex}{\out{\hypertarget{method-ISOIdentification19139-addKeywords}{}}}
\subsection{Method \code{addKeywords()}}{
Adds keywords
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOIdentification19139$addKeywords(keywords)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{keywords}}{object of class \link{ISOKeywords}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOIdentification19139-setKeywords"></a>}}
\if{latex}{\out{\hypertarget{method-ISOIdentification19139-setKeywords}{}}}
\subsection{Method \code{setKeywords()}}{
Set keywords
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOIdentification19139$setKeywords(keywords)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{keywords}}{object of class \link{ISOKeywords}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if set, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOIdentification19139-delKeywords"></a>}}
\if{latex}{\out{\hypertarget{method-ISOIdentification19139-delKeywords}{}}}
\subsection{Method \code{delKeywords()}}{
Deletes keywords
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOIdentification19139$delKeywords(keywords)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{keywords}}{object of class \link{ISOKeywords}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOIdentification19139-addResourceConstraints"></a>}}
\if{latex}{\out{\hypertarget{method-ISOIdentification19139-addResourceConstraints}{}}}
\subsection{Method \code{addResourceConstraints()}}{
Adds resource constraints
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOIdentification19139$addResourceConstraints(resourceConstraints)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{resourceConstraints}}{object of class \link{ISOConstraints}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOIdentification19139-delResourceConstraints"></a>}}
\if{latex}{\out{\hypertarget{method-ISOIdentification19139-delResourceConstraints}{}}}
\subsection{Method \code{delResourceConstraints()}}{
Deletes resource constraints
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOIdentification19139$delResourceConstraints(resourceConstraints)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{resourceConstraints}}{object of class \link{ISOConstraints}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOIdentification19139-addResourceSpecificUsage"></a>}}
\if{latex}{\out{\hypertarget{method-ISOIdentification19139-addResourceSpecificUsage}{}}}
\subsection{Method \code{addResourceSpecificUsage()}}{
Adds resource specific usage
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOIdentification19139$addResourceSpecificUsage(usage)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{usage}}{object of class \link{ISOUsage}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOIdentification19139-delResourceSpecificUsage"></a>}}
\if{latex}{\out{\hypertarget{method-ISOIdentification19139-delResourceSpecificUsage}{}}}
\subsection{Method \code{delResourceSpecificUsage()}}{
Deletes resource specific usage
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOIdentification19139$delResourceSpecificUsage(usage)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{usage}}{object of class \link{ISOUsage}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOIdentification19139-addAggregateInformation"></a>}}
\if{latex}{\out{\hypertarget{method-ISOIdentification19139-addAggregateInformation}{}}}
\subsection{Method \code{addAggregateInformation()}}{
Adds aggregate information
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOIdentification19139$addAggregateInformation(aggregateInfo)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{aggregateInfo}}{object of class \link{ISOAggregateInformation}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOIdentification19139-delAggregateInformation"></a>}}
\if{latex}{\out{\hypertarget{method-ISOIdentification19139-delAggregateInformation}{}}}
\subsection{Method \code{delAggregateInformation()}}{
Deletes aggregate information
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOIdentification19139$delAggregateInformation(aggregateInfo)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{aggregateInfo}}{object of class \link{ISOAggregateInformation}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOIdentification19139-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ISOIdentification19139-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOIdentification19139$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
