% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readISO.R
\name{readISO19139}
\alias{readISO19139}
\title{readISO19139}
\usage{
readISO19139(file, url, raw)
}
\arguments{
\item{file}{a valid file path, as object of class \code{character}}

\item{url}{a valid URL, as object of class \code{character}}

\item{raw}{indicates if the function should return the raw XML. By
default this is set to \code{FALSE} and the function will try to map
the xml data to the \pkg{geometa} data model.}
}
\value{
a \pkg{geometa} object inheriting \code{ISOAbstractObject}
}
\description{
\code{readISO19139} is a function to read a ISO 19139 from a file
or url into an object in the \pkg{geometa} model.
}
\examples{
\donttest{
  mdfile <- system.file("extdata/examples", "metadata.xml", package = "geometa")
  md <- readISO19139(mdfile)
}

}
\author{
Emmanuel Blondel, \email{emmanuel.blondel1@gmail.com}
}
