% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gs_polygon.R
\name{gs_polygon}
\alias{gs_polygon}
\alias{gs_triangle}
\alias{gs_square}
\alias{gs_rectangle}
\alias{gs_hexagon}
\title{Create a polygon \code{geom}}
\usage{
gs_polygon(anchor = NULL, window = NULL, features = 1,
  vertices = NULL, sketch = NULL, regular = FALSE, ...)

gs_triangle(anchor = NULL, window = NULL, sketch = NULL,
  features = 1, ...)

gs_square(anchor = NULL, window = NULL, sketch = NULL,
  features = 1, ...)

gs_rectangle(anchor = NULL, window = NULL, sketch = NULL,
  features = 1, ...)

gs_hexagon(anchor = NULL, window = NULL, sketch = NULL,
  features = 1, ...)
}
\arguments{
\item{anchor}{[\code{geom(1)}|\code{data.frame(1)}]\cr Object to derive the
\code{geom} from. It must include column names \code{x}, \code{y} and
optionally a custom \code{fid}. To set further attributes, use
\code{\link{setTable}}.}

\item{window}{[\code{data.frame(1)}]\cr in case the reference window deviates
from the bounding box of \code{anchor} (minimum and maximum values),
specify this here.}

\item{features}{[\code{integerish(1)}]\cr number of polygons to create.}

\item{vertices}{[\code{integerish(.)}]\cr number of vertices per polygon;
will be recycled if it does not have as many elements as specified in
\code{features}.}

\item{sketch}{[\code{RasterLayer(1)}|\code{matrix(1)}]\cr Gridded object that
serves as template to sketch polygons.}

\item{regular}{[\code{logical(1)}]\cr should the polygon be regular, i.e.
point symmetric (\code{TRUE}) or should the vertices be selected as
provided by \code{anchor} (\code{FALSE}, default)?}

\item{...}{[various]\cr additional arguments; see Details.}
}
\value{
An invisible \code{geom}.
}
\description{
Create any (regular) polygon geometry (of class \code{\link{geom}}) either by
specifying anchor values or by sketching it.
}
\details{
The arguments \code{anchor} and \code{sketch} indicate how the line
  is created: \itemize{ \item if \code{anchor} is set, the line is created
  parametrically from the given objects' points, \item if an object is set in
  \code{sketch}, this is used to create the \code{geom} interactively, by
  clicking into the plot.}

  The argument \code{regular} determines how the vertices provided in
  \code{anchor} or via \code{sketch} are transformed into a polygon:
  \itemize{ \item if \code{regular = FALSE} the resulting polygon is created
  from all vertices in \code{anchor}, \item if \code{regular = TRUE}, only
  the first two vertices are considered, as center and indicating the
  distance to the (outer) radius.}

  Possible additional arguments are: \itemize{ \item verbose = TRUE/FALSE
  \item graphical parameters to \code{\link{gt_locate}}, in case points are
  sketched; see \code{\link[grid]{gpar}}}
}
\section{Functions}{
\itemize{
\item \code{gs_triangle}: wrapper of gs_polygon where \code{vertices = 3} and
\code{regular = TRUE}.

\item \code{gs_square}: wrapper of gs_polygon where \code{vertices = 4} and
\code{regular = TRUE}.

\item \code{gs_rectangle}: wrapper of gs_polygon where \code{vertices = 2},
\code{regular = FALSE} and the two complementing corners are derived from
the two given opposing corners.

\item \code{gs_hexagon}: wrapper of gs_polygon where \code{vertices = 6} and
\code{regular = TRUE}.
}}

\examples{
# 1. create a polygon programmatically
coords <- data.frame(x = c(40, 70, 70, 50),
                     y = c(40, 40, 60, 70))

# if no window is set, the bounding box will be set as window
(aGeom <- gs_polygon(anchor = coords))

# the vertices are plottet relative to the window
library(magrittr)
window <- data.frame(x = c(0, 80),
                     y = c(0, 80))
gs_polygon(anchor = coords, vertices = 6, window = window,
           regular = TRUE) \%>\%
  visualise(linecol = "green")

# if a plot is already open, vertices are set relative to its' window
visualise(geom = gs_triangle(anchor = coords), new = FALSE)

# when a geom is used in 'anchor', its properties are passed on
aGeom <- setWindow(x = aGeom, to = window)
gs_polygon(anchor = aGeom) \%>\%
  visualise(geom = ., fillcol = "deeppink")
gs_rectangle(anchor = aGeom) \%>\%
  visualise(geom = ., new = FALSE)
\donttest{
# 2. sketch a hexagon by clicking into a template
gs_hexagon(sketch = gtRasters$continuous) \%>\%
  visualise(geom = ., linecol = "deeppink", linetype = 2, new = FALSE)
}
}
\seealso{
Other geometry shapes: \code{\link{gs_line}},
  \code{\link{gs_point}}, \code{\link{gs_random}}
}
\concept{geometry shapes}
