% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_scale.R
\name{gt_scale}
\alias{gt_scale}
\title{Scale \code{geom}s}
\usage{
gt_scale(geom, range = NULL, to = "relative")
}
\arguments{
\item{geom}{[\code{geom(.)}]\cr the object to be scaled.}

\item{range}{[\code{list(2)}]\cr vector of length two for both of the
\code{x} and \code{y} dimension to which the values should be scaled.}

\item{to}{[\code{character(1)}]\cr the scale to which the coordinates should
be transformed; possible are \code{"relative"} and \code{"absolute"};
ignored in case \code{range != NULL}.}
}
\value{
Scaled \code{geom}.
}
\description{
Scale the vertex values of \code{geom}s to a values range or so that they are
either relative to the \code{@window} slot, or absolute values.
}
\examples{
coords <- data.frame(x = c(40, 70, 70, 50, 40),
                     y = c(40, 40, 60, 70, 40),
                     fid = 1)
window <- data.frame(x = c(0, 80),
                     y = c(0, 80))
aGeom <- gs_polygon(anchor = coords, window = window)

# change to relative scale and back to absolute
(relCoords <- gt_scale(geom = aGeom, to = "relative"))
gt_scale(geom = relCoords, to = "absolute")

# scale to another range
gt_scale(geom = aGeom, range = list(x = c(0, 100), y = c(10, 90)))

}
\seealso{
Other geometry tools: 
\code{\link{gt_reflect}()},
\code{\link{gt_rotate}()},
\code{\link{gt_sketch}()},
\code{\link{gt_skew}()},
\code{\link{gt_stretch}()},
\code{\link{gt_translate}()}
}
\concept{geometry tools}
