context("query")
test_that("query returns a list of data.frames",{
  testthat::skip_on_cran()
  output <- geoparser_q(text_input = "Paris o Paris and Paris")
  expect_is(output, "list")
  expect_is(output$properties, "tbl_df")
  expect_is(output$results, "tbl_df")
  expect_is(output$results$longitude, "numeric")
  expect_is(output$results$latitude, "numeric")
  expect_is(output$results$reference1, "numeric")
  expect_is(output$results$reference2, "numeric")
  expect_true(nrow(output$results) > 1)
  output <- geoparser_q(text_input = c("Paris o Paris and Paris", "Soon I will travel to Munich" , "I live in Barcelona"))
  expect_is(output, "list")
  expect_is(output$properties, "tbl_df")
  expect_is(output$results, "tbl_df")
  expect_is(output$results$longitude, "numeric")
  expect_is(output$results$latitude, "numeric")
  expect_is(output$results$reference1, "numeric")
  expect_is(output$results$reference2, "numeric")
  expect_true(nrow(output$results) > 1)
})

test_that("no problems if no results",{
  testthat::skip_on_cran()
  output <- geoparser_q(text_input = "no placename here")
  expect_is(output, "list")
  expect_is(output$properties, "tbl_df")
  expect_is(output$results, "tbl_df")
})

