% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GSDataStore.R
\docType{class}
\name{GSDataStore}
\alias{GSDataStore}
\title{Geoserver REST API DataStore}
\format{\code{\link{R6Class}} object.}
\usage{
GSDataStore
}
\value{
Object of \code{\link{R6Class}} for modelling a GeoServer dataStore
}
\description{
Geoserver REST API DataStore
}
\section{Fields}{

\describe{
\item{\code{workspace}}{}
}}

\section{Methods}{

\describe{
 \item{\code{new(xml, dataStore, description, type, enabled, connectionParameters)}}{
   This method is used to instantiate a GSDataStore
 }
 \item{\code{decode(xml)}}{
   This method is used to decode a GSDataStore from XML
 }
 \item{\code{encode()}}{
   This method is used to encode a GSNamespace to XML. Inherited from the
   generic \code{GSRESTResource} encoder
 }
 \item{\code{setEnabled(enabled)}}{
   Sets the datastore as enabled if TRUE, disabled if FALSE
 }
 \item{\code{setDescription(description)}}{
   Sets the datastore description
 }
 \item{\code{setType(type)}}{
   Sets the datastore type
 }
 \item{\code{setConnectionParameters(parameters)}}{
   Sets the datastore connection parameters. The argument should be an object
   of class \code{GSRESTEntrySet} giving a list of key/value parameter entries.
 }
 \item{\code{addConnectionParameter(key, value)}}{
   Adds a datastore connection parameter. Convenience wrapper of \code{GSRESTEntrySet} 
   \code{addEntry} method.
 }
 \item{\code{setConnectionParameter(key, value)}}{
   Sets a datastore connection parameter. Convenience wrapper of \code{GSRESTEntrySet} 
   \code{setEntry} method.
 }
 \item{\code{delConnectionParameter(key)}}{
   Deletes a datastore connection parameter. Convenience wrapper of \code{GSRESTEntrySet} 
   \code{delEntry} method.
 }
}
}

\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{DataStore}
\keyword{api}
\keyword{geoserver}
\keyword{rest}
