% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GSAbstractDBDataStore.R
\docType{class}
\name{GSAbstractDBDataStore}
\alias{GSAbstractDBDataStore}
\title{Geoserver REST API AbstractDBDataStore}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} for modelling a GeoServer abstract DB dataStore
}
\description{
Geoserver REST API AbstractDBDataStore
}
\note{
Internal abstract class used for setting DB stores
}
\section{Methods}{

\describe{
   \item{\code{new(xml, dataStore, description, enabled)}}{
     Instantiates a GSAbstractDBDataStore object
   }
   \item{\code{setDatabaseType(dbtype)}}{
     Sets the database type
   }
   \item{\code{setNamespace(namespace)}}{
     Sets the datastore namespace
   }
   \item{\code{setHost(host)}}{
     Sets the database host
   }
   \item{\code{setPort(port)}}{
     Set the database port
   }
   \item{\code{setDatabase(database)}}{
     Set the database name
   }
   \item{\code{setSchema(schema)}}{
     Set the database schema
   }
   \item{\code{setUser(user)}}{
     Set the database username
   }
   \item{\code{setPassword(password)}}{
     Set the database password
   }
   \item{\code{setJndiReferenceName(jndiReferenceName)}}{
     Set a JNDI reference name
   }
   \item{\code{setExposePrimaryKeys(exposePrimaryKeys)}}{
     Set TRUE if primary keys have to be exposed to datastore, FALSE otherwise.
   }
   \item{\code{setMaxConnections(maxConnections)}}{
     Set the maximum number of connections. Default is set to 10.
   }
   \item{\code{setMinConnections(minConnections)}}{
     Set the minimum number of connections. Default is set to 1.
   }
   \item{\code{setFetchSize(fetchSize)}}{
     Set the fetch size. Default is set to 10.
   }
   \item{\code{setConnectionTimeout(seconds)}}{
     Set the connection timeout. Default is set to 20s.
   }
   \item{\code{setValidateConnections(validateConnections)}}{
     Set TRUE if connections have to be validated, FALSE otherwise.
   }
   \item{\code{setPrimaryKeyMetadataTable(primaryKeyMetadataTable)}}{
     Set the name of the primaryKey metadata table
   }
   \item{\code{setLooseBBox(looseBBox)}}{
     Set losse bbox parameter.
   }
   \item{\code{setPreparedStatements(preparedStatements)}}{
     Set prepared statements
   }
   \item{\code{setMaxOpenPreparedStatements(maxOpenPreparedStatements)}}{
     Set maximum open prepared statements
   }
   \item{\code{setEstimatedExtends(estimatedExtends)}}{
     Set estimatedExtend parameter
   }
   \item{\code{setDefautConnectionParameters()}}{
     Set default connection parameters
   }
}
}

\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{DB}
\keyword{DataStore}
\keyword{api}
\keyword{database}
\keyword{geoserver}
\keyword{rest}
