% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GSWorkspaceManager.R
\docType{class}
\name{GSWorkspaceManager}
\alias{GSWorkspaceManager}
\title{Geoserver REST API Workspace Manager}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} with methods for managing the workspaces
 of a GeoServer instance.
}
\description{
Geoserver REST API Workspace Manager

Geoserver REST API Workspace Manager
}
\examples{
\dontrun{
   GSWorkspaceManager$new("http://localhost:8080/geoserver", "admin", "geoserver")
}

}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{api}
\keyword{geoserver}
\keyword{rest}
\keyword{workspace}
\section{Super class}{
\code{\link[geosapi:GSManager]{geosapi::GSManager}} -> \code{GSWorkspaceManager}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-GSWorkspaceManager-getWorkspaces}{\code{GSWorkspaceManager$getWorkspaces()}}
\item \href{#method-GSWorkspaceManager-getWorkspaceNames}{\code{GSWorkspaceManager$getWorkspaceNames()}}
\item \href{#method-GSWorkspaceManager-getWorkspace}{\code{GSWorkspaceManager$getWorkspace()}}
\item \href{#method-GSWorkspaceManager-createWorkspace}{\code{GSWorkspaceManager$createWorkspace()}}
\item \href{#method-GSWorkspaceManager-updateWorkspace}{\code{GSWorkspaceManager$updateWorkspace()}}
\item \href{#method-GSWorkspaceManager-deleteWorkspace}{\code{GSWorkspaceManager$deleteWorkspace()}}
\item \href{#method-GSWorkspaceManager-getWorkspaceSettings}{\code{GSWorkspaceManager$getWorkspaceSettings()}}
\item \href{#method-GSWorkspaceManager-createWorkspaceSettings}{\code{GSWorkspaceManager$createWorkspaceSettings()}}
\item \href{#method-GSWorkspaceManager-updateWorkspaceSettings}{\code{GSWorkspaceManager$updateWorkspaceSettings()}}
\item \href{#method-GSWorkspaceManager-deleteWorkspaceSettings}{\code{GSWorkspaceManager$deleteWorkspaceSettings()}}
\item \href{#method-GSWorkspaceManager-clone}{\code{GSWorkspaceManager$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="ERROR"><a href='../../geosapi/html/GSManager.html#method-GSManager-ERROR'><code>geosapi::GSManager$ERROR()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="INFO"><a href='../../geosapi/html/GSManager.html#method-GSManager-INFO'><code>geosapi::GSManager$INFO()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="WARN"><a href='../../geosapi/html/GSManager.html#method-GSManager-WARN'><code>geosapi::GSManager$WARN()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="connect"><a href='../../geosapi/html/GSManager.html#method-GSManager-connect'><code>geosapi::GSManager$connect()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="getClassName"><a href='../../geosapi/html/GSManager.html#method-GSManager-getClassName'><code>geosapi::GSManager$getClassName()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="getCoverageStoreManager"><a href='../../geosapi/html/GSManager.html#method-GSManager-getCoverageStoreManager'><code>geosapi::GSManager$getCoverageStoreManager()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="getDataStoreManager"><a href='../../geosapi/html/GSManager.html#method-GSManager-getDataStoreManager'><code>geosapi::GSManager$getDataStoreManager()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="getNamespaceManager"><a href='../../geosapi/html/GSManager.html#method-GSManager-getNamespaceManager'><code>geosapi::GSManager$getNamespaceManager()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="getServiceManager"><a href='../../geosapi/html/GSManager.html#method-GSManager-getServiceManager'><code>geosapi::GSManager$getServiceManager()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="getStyleManager"><a href='../../geosapi/html/GSManager.html#method-GSManager-getStyleManager'><code>geosapi::GSManager$getStyleManager()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="getSystemStatus"><a href='../../geosapi/html/GSManager.html#method-GSManager-getSystemStatus'><code>geosapi::GSManager$getSystemStatus()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="getUrl"><a href='../../geosapi/html/GSManager.html#method-GSManager-getUrl'><code>geosapi::GSManager$getUrl()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="getWorkspaceManager"><a href='../../geosapi/html/GSManager.html#method-GSManager-getWorkspaceManager'><code>geosapi::GSManager$getWorkspaceManager()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="initialize"><a href='../../geosapi/html/GSManager.html#method-GSManager-initialize'><code>geosapi::GSManager$initialize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="logger"><a href='../../geosapi/html/GSManager.html#method-GSManager-logger'><code>geosapi::GSManager$logger()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="monitor"><a href='../../geosapi/html/GSManager.html#method-GSManager-monitor'><code>geosapi::GSManager$monitor()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="reload"><a href='../../geosapi/html/GSManager.html#method-GSManager-reload'><code>geosapi::GSManager$reload()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSWorkspaceManager-getWorkspaces"></a>}}
\if{latex}{\out{\hypertarget{method-GSWorkspaceManager-getWorkspaces}{}}}
\subsection{Method \code{getWorkspaces()}}{
Get the list of available workspace. Returns an object of class \code{list}
   containing items of class \code{\link{GSWorkspace}}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSWorkspaceManager$getWorkspaces()}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{a}}{list of \link{GSWorkspace}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSWorkspaceManager-getWorkspaceNames"></a>}}
\if{latex}{\out{\hypertarget{method-GSWorkspaceManager-getWorkspaceNames}{}}}
\subsection{Method \code{getWorkspaceNames()}}{
Get the list of available workspace names. Returns an vector of class \code{character}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSWorkspaceManager$getWorkspaceNames()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
a list of workspace names
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSWorkspaceManager-getWorkspace"></a>}}
\if{latex}{\out{\hypertarget{method-GSWorkspaceManager-getWorkspace}{}}}
\subsection{Method \code{getWorkspace()}}{
Get a \code{\link{GSWorkspace}} object given a workspace name.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSWorkspaceManager$getWorkspace(ws)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ws}}{workspace name}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
an object of class \link{GSWorkspace}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSWorkspaceManager-createWorkspace"></a>}}
\if{latex}{\out{\hypertarget{method-GSWorkspaceManager-createWorkspace}{}}}
\subsection{Method \code{createWorkspace()}}{
Creates a GeoServer workspace given a name, and an optional URI. If the URI
   is not specified, GeoServer will automatically create an associated Namespace 
   with the URI being "http://{workspaceName}. If the URI is specified, the method
   invokes the method \code{createNamespace(ns, uri)} of the \code{\link{GSNamespaceManager}}.
   Returns \code{TRUE} if the workspace has been successfully created, \code{FALSE} otherwise
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSWorkspaceManager$createWorkspace(name, uri)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{name}

\item{\code{uri}}{uri}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if created, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSWorkspaceManager-updateWorkspace"></a>}}
\if{latex}{\out{\hypertarget{method-GSWorkspaceManager-updateWorkspace}{}}}
\subsection{Method \code{updateWorkspace()}}{
Updates a GeoServer workspace given a name, and an optional URI. If the URI
   is not specified, GeoServer will automatically update the associated Namespace 
   with the URI being "http://{workspaceName}. If the URI is specified, the method
   invokes the method \code{updateNamespace(ns, uri)} of the \code{\link{GSNamespaceManager}}.
   Returns \code{TRUE} if the workspace has been successfully updated, \code{FALSE} otherwise
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSWorkspaceManager$updateWorkspace(name, uri)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{name}

\item{\code{uri}}{uri}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if created, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSWorkspaceManager-deleteWorkspace"></a>}}
\if{latex}{\out{\hypertarget{method-GSWorkspaceManager-deleteWorkspace}{}}}
\subsection{Method \code{deleteWorkspace()}}{
Deletes a GeoServer workspace given a name.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSWorkspaceManager$deleteWorkspace(name, recurse = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{name}

\item{\code{recurse}}{recurse}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if the workspace has been successfully deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSWorkspaceManager-getWorkspaceSettings"></a>}}
\if{latex}{\out{\hypertarget{method-GSWorkspaceManager-getWorkspaceSettings}{}}}
\subsection{Method \code{getWorkspaceSettings()}}{
Updates workspace settings
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSWorkspaceManager$getWorkspaceSettings(ws)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ws}}{workspace name}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
an object of class \link{GSWorkspaceSettings}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSWorkspaceManager-createWorkspaceSettings"></a>}}
\if{latex}{\out{\hypertarget{method-GSWorkspaceManager-createWorkspaceSettings}{}}}
\subsection{Method \code{createWorkspaceSettings()}}{
Creates workspace settings
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSWorkspaceManager$createWorkspaceSettings(ws, workspaceSettings)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ws}}{workspace name}

\item{\code{workspaceSettings}}{object of class \link{GSWorkspaceSettings}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if created, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSWorkspaceManager-updateWorkspaceSettings"></a>}}
\if{latex}{\out{\hypertarget{method-GSWorkspaceManager-updateWorkspaceSettings}{}}}
\subsection{Method \code{updateWorkspaceSettings()}}{
Updates workspace settings
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSWorkspaceManager$updateWorkspaceSettings(ws, workspaceSettings)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ws}}{workspace name}

\item{\code{workspaceSettings}}{object of class \link{GSWorkspaceSettings}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if updated, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSWorkspaceManager-deleteWorkspaceSettings"></a>}}
\if{latex}{\out{\hypertarget{method-GSWorkspaceManager-deleteWorkspaceSettings}{}}}
\subsection{Method \code{deleteWorkspaceSettings()}}{
Deletes workspace settings
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSWorkspaceManager$deleteWorkspaceSettings(ws)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ws}}{workspace name}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSWorkspaceManager-clone"></a>}}
\if{latex}{\out{\hypertarget{method-GSWorkspaceManager-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSWorkspaceManager$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
