% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gos_bestkappa.R
\name{gos_bestkappa}
\alias{gos_bestkappa}
\title{function for the best kappa parameter}
\usage{
gos_bestkappa(
  formula,
  data = NULL,
  kappa = seq(0.05, 1, 0.05),
  nrepeat = 10,
  nsplit = 0.5,
  cores = 1
)
}
\arguments{
\item{formula}{A formula of GOS model.}

\item{data}{A data.frame or tibble of observation data.}

\item{kappa}{(optional) A numeric value of the percentage of observation locations
with high similarity to a prediction location. \eqn{kappa = 1 - tau}, where \code{tau} is
the probability parameter in quantile operator. kappa is 0.25 means that 25\% of
observations with high similarity to a prediction location are used for modelling.}

\item{nrepeat}{(optional) A numeric value of the number of cross-validation training times.
The default value is \code{10}.}

\item{nsplit}{(optional) The sample training set segmentation ratio,which in \verb{(0,1)}.
Default is \code{0.5}.}

\item{cores}{(optional) Positive integer. If cores > 1, a \code{parallel} package
cluster with that many cores is created and used. You can also supply a cluster
object. Default is \code{1}.}
}
\value{
A list of the result of the best kappa and the computation process curve.
\describe{
\item{\code{bestkappa}}{the result of best kappa}
\item{\code{cvrmse}}{all RMSE calculations during cross-validation}
\item{\code{cvmean}}{the average RMSE corresponding to different kappa in the cross-validation process}
\item{\code{plot}}{the plot of rmse changes corresponding to different kappa}
}
}
\description{
Computationally optimized function for determining the best kappa parameter for the optimal similarity
}
\examples{
data("zn")
# log-transformation
hist(zn$Zn)
zn$Zn <- log(zn$Zn)
hist(zn$Zn)
# remove outliers
k <- removeoutlier(zn$Zn, coef = 2.5)
dt <- zn[-k,]
# determine the best kappa
system.time({
b1 <- gos_bestkappa(Zn ~ Slope + Water + NDVI  + SOC + pH + Road + Mine,
                    data = dt,
                    kappa = c(0.01, 0.1, 1),
                    nrepeat = 1,
                    cores = 1)
})
b1$bestkappa
b1$plot

}
\references{
Song, Y. (2022). Geographically Optimal Similarity. Mathematical Geosciences. doi: 10.1007/s11004-022-10036-8.
}
