% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04-crop-analysis.R
\name{get_comprehensive_cdl_codes}
\alias{get_comprehensive_cdl_codes}
\title{Get comprehensive CDL crop codes}
\usage{
get_comprehensive_cdl_codes(crop_type = "all")
}
\arguments{
\item{crop_type}{Crop type or category name. Options include:
\itemize{
\item Individual crops: "corn", "soybeans", "wheat", etc.
\item Categories: "grains", "oilseeds", "fruits", "vegetables", etc.
\item "all" for all available codes
}}
}
\value{
Vector of CDL codes
}
\description{
Get USDA Cropland Data Layer (CDL) codes for specific crops or crop categories.
Supports all major crops and predefined categories.
}
\examples{
\donttest{
# Get corn code
corn_codes <- get_comprehensive_cdl_codes("corn")
print(corn_codes)  # Should be 1

# Get all grain crop codes
grain_codes <- get_comprehensive_cdl_codes("grains")
print(grain_codes)  # Should be vector of grain codes

# See available crop types (this will print to console)
get_comprehensive_cdl_codes("help")
}

}
