% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convenience-functions.R
\name{sp_diag}
\alias{sp_diag}
\alias{sp_diag.geostan_fit}
\alias{sp_diag.numeric}
\title{Spatial data diagnostics}
\usage{
sp_diag(
  y,
  shape,
  name = "y",
  plot = TRUE,
  mc_style = c("scatter", "hist"),
  style = c("W", "B"),
  w = shape2mat(shape, match.arg(style)),
  binwidth = function(x) 0.5 * sd(x, na.rm = TRUE),
  ...
)

\method{sp_diag}{geostan_fit}(
  y,
  shape,
  name = "Residual",
  plot = TRUE,
  mc_style = c("scatter", "hist"),
  style = c("W", "B"),
  w = shape2mat(shape, match.arg(style)),
  binwidth = function(x) 0.5 * stats::sd(x, na.rm = TRUE),
  rates = TRUE,
  size = 0.15,
  ...
)

\method{sp_diag}{numeric}(
  y,
  shape,
  name = "y",
  plot = TRUE,
  mc_style = c("scatter", "hist"),
  style = c("W", "B"),
  w = shape2mat(shape, match.arg(style)),
  binwidth = function(x) 0.5 * stats::sd(x, na.rm = TRUE),
  ...
)
}
\arguments{
\item{y}{A numeric vector, or a fitted \code{geostan} model (class \code{geostan_fit}).}

\item{shape}{An object of class \code{sf} or another spatial object coercible to \code{sf} with \code{sf::st_as_sf} such as \code{SpatialPolygonsDataFrame}.}

\item{name}{The name to use on the plot labels; default to "y" or, if \code{y} is a \code{geostan_fit} object, to "Residuals".}

\item{plot}{If \code{FALSE}, return a list of \code{gg} plots.}

\item{mc_style}{Character string indicating how to plot the residual Moran coefficient (only used if \code{y} is a fitted model): if \code{mc = "scatter"}, then \code{\link[geostan]{moran_plot}} will be used with the marginal residuals; if \code{mc = "hist"}, then a histogram of Moran coefficient values will be returned, where each plotted value represents the degree of residual autocorrelation in a draw from the join posterior distribution of model parameters.}

\item{style}{Style of connectivity matrix; if \code{w} is not provided, \code{style} is passed to \code{\link[geostan]{shape2mat}} and defaults to "W" for row-standardized.}

\item{w}{An optional spatial connectivity matrix; if not provided, one will be created using \code{\link[geostan]{shape2mat}}.}

\item{binwidth}{A function with a single argument that will be passed to the \code{binwidth} argument in \code{\link[ggplot2]{geom_histogram}}. The default is to set the width of bins to \code{0.5 * sd(x)}.}

\item{...}{Additional arguments passed to \code{\link[geostan]{residuals.geostan_fit}}. For binomial and Poisson models, this includes the option to view the outcome variable as a rate (the default) rather than a count; for \code{\link[geostan]{stan_car}} models with auto-Gaussian likelihood (\verb{fit$family$family = "auto_gaussian"), the residuals will be detrended by default, but this can be changed using }detrend = FALSE`.}

\item{rates}{For Poisson and binomial models, convert the outcome variable to a rate before calculating residuals. Defaults to \code{rates = TRUE}.}

\item{size}{Point size and linewidth for point-interval plot of observed vs. fitted values (passed to \code{\link[ggplot2]{geom_pointrange}}).}
}
\value{
A grid of spatial diagnostic plots. When provided with a numeric vector, this function plots a histogram, Moran scatter plot, and map. When provided with a fitted \code{geostan} model, the function returns a point-interval plot of observed values against fitted values (mean and 95 percent credible interval), either a Moran scatter plot of residuals or a histogram of Moran coefficient values calculated from the joint posterior distribution of the residuals, and a map of the mean posterior residuals (means of the marginal distributions).

If \code{plot = TRUE}, the \code{ggplots} are drawn using \code{\link[gridExtra]{grid.arrange}}; otherwise, they are returned in a list. For the \code{geostan_fit} method, the underlying data for the Moran coefficient will also be returned if \code{plot = FALSE}.
}
\description{
Visual diagnostics for areal data and model residuals
}
\examples{
\donttest{
data(georgia)
sp_diag(georgia$college, georgia)

bin_fn <- function(y) mad(y, na.rm = TRUE)
sp_diag(georgia$college, georgia, binwidth = bin_fn)

fit <- stan_glm(log(rate.male) ~ log(income),
                data = georgia,
                chains = 2, iter = 800) # for speed only
sp_diag(fit, georgia)
}
}
\seealso{
\code{\link[geostan]{me_diag}}, \code{\link[geostan]{mc}}, \code{\link[geostan]{moran_plot}}, \code{\link[geostan]{aple}}
}
