% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drybrush.R
\name{drybrush}
\alias{drybrush}
\title{Simulates a dry brushing effect. Differs from elevation_transparency() in that colour is applied based on local altitude peaks, not across the whole raster}
\usage{
drybrush(raster_dem, aggregation_factor = 10, max_colour_altitude = 30,
  opacity = 0.5, elevation_palette = c("#3f3f3f", "#ffa500"))
}
\arguments{
\item{raster_dem}{A raster}

\item{aggregation_factor}{grid size to determine local altitude peaks}

\item{max_colour_altitude}{Altitude below which colours will be graduated across elevation_palette}

\item{opacity}{overall opacity of the returned image}

\item{elevation_palette}{Colour scheme c(colour_for_low_altitude, colour_for_high_altitude)}
}
\value{
An image with a drybrushed colour effect, highlighting local peaks
}
\description{
Simulates a dry brushing effect. Differs from elevation_transparency() in that colour is applied based on local altitude peaks, not across the whole raster
}
\examples{
overlay_image <- drybrush(example_raster())
}
