% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optiRG.R
\name{optiRG}
\alias{optiRG}
\title{optiRG join two zones close to each other}
\usage{
optiRG(K, map, iC, iZC, simplitol = 0.001, disp = 0)
}
\arguments{
\item{K}{zoning object (such as returned by calNei function)}

\item{map}{object returned by function genMap}

\item{iC}{first zone}

\item{iZC}{second zone}

\item{simplitol}{tolerance for spatial polygons geometry simplification}

\item{disp}{0: no info, 1: detailed info}
}
\value{
a zoning object
}
\description{
optiRG join two zones close to each other
}
\details{
Within a zoning, two zones close to each other are geometrically joined. The zoning is updated accordingly. If the zone resulting from the junction is not valid, i.e. if it crosses another zone, the function returns NULL.
}
\examples{
data(mapTest)
qProb=c(0.2,0.5)
ZK = initialZoning(qProb, mapTest)
K=ZK$resZ
Z=K$zonePolygone
plotZ(K$zonePolygone) # zoning
kmi=optiRG(K,mapTest,6,7,disp=1)
#zones 6 and 7 are joined into new zone 6
sp::plot(kmi$zonePolygone[[6]],col="red",add=TRUE)
}
