% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ignore.R
\name{git_ignore}
\alias{git_ignore}
\alias{git_ignore_path_is_ignored}
\title{Git Ignore}
\usage{
git_ignore_path_is_ignored(path, repo = ".")
}
\arguments{
\item{path}{A character vector of paths to test within the repo}

\item{repo}{The path to the git repository. If the directory is not a
repository, parent directories are considered (see \link{git_find}). To disable
this search, provide the filepath protected with \code{\link[=I]{I()}}. When using this
parameter, always explicitly call by name (i.e. \verb{repo = }) because future
versions of gert may have additional parameters.}
}
\value{
A logical vector the same length as \code{path}, indicating if the
paths would be ignored.
}
\description{
Test if files would be ignored by \code{.gitignore} rules
}
\seealso{
Other git: 
\code{\link{git_archive}},
\code{\link{git_branch}()},
\code{\link{git_commit}()},
\code{\link{git_config}()},
\code{\link{git_diff}()},
\code{\link{git_fetch}()},
\code{\link{git_merge}()},
\code{\link{git_rebase}()},
\code{\link{git_remote}},
\code{\link{git_repo}},
\code{\link{git_signature}()},
\code{\link{git_stash}},
\code{\link{git_tag}}
}
\concept{git}
