% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalizeByDoi.R
\name{normalizeByDoi}
\alias{normalizeByDoi}
\title{normalizeByDoi}
\usage{
normalizeByDoi(
  dataframe,
  doi = "doi",
  year = "ano.do.artigo",
  issn = "issn",
  paperTitle = "titulo.do.artigo",
  journalName = "titulo.do.periodico.ou.revista"
)
}
\arguments{
\item{dataframe}{data imported with readLattes() then getArtigosPublicados()}

\item{doi}{variable with DOI code}

\item{year}{variable with year}

\item{issn}{variable with issn}

\item{paperTitle}{variable with paper title}

\item{journalName}{variable with journal name}
}
\value{
data frame
}
\description{
Normalize articles data: title, journal name, ISSN, and year by DOI code. The most common information (title, journal name, ISSN, and year) will be inserted into all articles with the same DOI code.
}
\details{
Curriculum without this information will return NULL.
}
\examples{
if(interactive()){
data(latesXML)
al <- lapply(xmlsLattes, getArtigosPublicados) 
adf <- bind_rows(al)

head(
    normalizeByDoi(dataframe=adf, 
              doi='doi', 
              year='ano.do.artigo', 
              issn='issn', 
              paperTitle='titulo.do.artigo', 
              journalName= 'titulo.do.periodico.ou.revista')
) 
}
}
\seealso{
\code{\link[dplyr]{group_by}},\code{\link[dplyr]{arrange}},\code{\link[dplyr]{mutate}}
}
