% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getMet.R
\name{getMet}
\alias{getMet}
\title{Gets met data from a specified source and creates model input files in the specified format}
\usage{
getMet(locations, dataSource = "cfsr", outFormat = "swat",
  outDir = getwd())
}
\arguments{
\item{locations}{- data.frame object or location of csv file with two columns, the first being lattitude and second being longidute in decimal degrees. These locations will be the locations of the collected met data.}

\item{dataSource}{- Source of met data from predefined source list. Currenly only 'cfsr' is supported.}

\item{outFormat}{- Format of met data output from predefined source. Currently only 'swat' is supported.}

\item{outDir}{- Directory where ouput files will be saved}
}
\value{
returns specified  met data in specified format
}
\description{
Gets met data from a specified source and creates model input files in the specified format
}
\examples{
\dontrun{
locations = data.frame(lat = 38, lon = 79)
outDir = "test"
getMet(locations=locations, outDir=outDir)
}
}

