% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/admin.R
\name{admin_startRPC}
\alias{admin_startRPC}
\title{HTTP based JSON RPC API initialization.}
\usage{
admin_startRPC(host = "127.0.0.1", port = 8545, cors = "",
  apis = "eth,net,web3")
}
\arguments{
\item{host}{String - Network interface to open the listener socket on.}

\item{port}{Integer - Network port to open the listener socket on.}

\item{cors}{String - Cross-origin resource sharing header to use.}

\item{apis}{String - API modules to offer over this interface.}
}
\value{
Boolean - \code{true} the execution was successful.
}
\description{
\code{admin_startRPC} starts an HTTP based JSON RPC API webserver to handle
client requests.
}
\examples{
\donttest{
admin_startRPC()
admin_startRPC('193.23.92.1', 8999, '*', 'eth,net,web3,personal,shh,miner,
txpool,admin,debug')
}

}
\seealso{
Other admin functions: \code{\link{admin_addPeer}},
  \code{\link{admin_datadir}},
  \code{\link{admin_nodeInfo}}, \code{\link{admin_peers}},
  \code{\link{admin_setSolc}}, \code{\link{admin_startWS}},
  \code{\link{admin_stopRPC}}, \code{\link{admin_stopWS}},
  \code{\link{gethr}}
}
\concept{admin functions}
