% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robust_isatpanel.R
\name{robust_isatpanel}
\alias{robust_isatpanel}
\title{Get robust Standard Errors for the isatpanel result}
\usage{
robust_isatpanel(
  object,
  robust = TRUE,
  HAC = FALSE,
  lag = NULL,
  effect = "twoways",
  type = "HC0",
  cluster = "group"
)
}
\arguments{
\item{object}{An isatpanel object}

\item{robust}{Logical (TRUE or FALSE). Should the Standard Errors be robustified for Heterogeneity?}

\item{HAC}{Should Heteroscedasticity and Autocorrelation Robust Standard Errors be used?}

\item{lag}{Number of Lags to be used with HAC in coeftest. Cannot be specified when HAC = FALSE.}

\item{effect}{The effects introduced into the plm model, one of "individual", "time", "twoways" (default), or "nested"}

\item{type}{Type of Robust procedure e.g. HC0 for White SE or HC3 for Lang}

\item{cluster}{'group' or 'time' or FALSE}
}
\value{
A list with robust estimates
}
\description{
Get robust Standard Errors for the isatpanel result
}
\examples{
\donttest{
data(EU_emissions_road)

# Group specification
EU15 <- c("Austria", "Germany", "Denmark", "Spain", "Finland", "Belgium",
         "France", "United Kingdom", "Ireland", "Italy", "Luxembourg",
         "Netherlands", "Greece", "Portugal", "Sweden")

# Prepare sample and data
EU_emissions_road_short <- EU_emissions_road[
EU_emissions_road$country \%in\% EU15 &
EU_emissions_road$year >= 2000,
]

# Run
result <- isatpanel(
  data = EU_emissions_road_short,
  formula = ltransport.emissions ~ lgdp + I(lgdp^2) + lpop,
  index = c("country", "year"),
  effect = "twoways",
  fesis = TRUE,
  plot = FALSE,
  t.pval = 0.01
)
plot(result)
plot_grid(result)
robust_isatpanel(result)
}

}
