% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gfilinreg.R
\name{gfilinreg}
\alias{gfilinreg}
\title{Fiducial sampler for linear regression model}
\usage{
gfilinreg(
  formula,
  data = NULL,
  distr = "student",
  df = Inf,
  L = 30L,
  stopifbig = TRUE
)
}
\arguments{
\item{formula}{two-sided formula defining the model}

\item{data}{dataframe containing the data}

\item{distr}{the distribution of the error terms, \code{"normal"},
\code{"student"}, \code{"cauchy"}, or \code{"logistic"}}

\item{df}{degrees of freedom of the Student distribution if
\code{distr = "student"}}

\item{L}{number of subdivisions of each axis of the hypercube
\code{(0,1)^(p+1)}}

\item{stopifbig}{logical, whether to stop if the algorithm requires huge 
matrices}
}
\value{
A \code{gfilinreg} object, list with the fiducial samples and the
  weights.
}
\description{
Weighted samples of the fiducial distribution of the
  parameters of a linear regression model with normal, Student, Cauchy, or
  logistic error terms.
}
\examples{
set.seed(666L)
x <- c(1, 2, 3, 4)
y <- x + 3 * rcauchy(4L)
gfi <- gfilinreg(y ~ x, distr = "cauchy", L = 30L)
gfiSummary(gfi)

}
\references{
Jan Hannig, Randy C.S. Lai, Thomas C.M. Lee. 
  \emph{Computational issues of generalized fiducial inference}.
  Computational Statistics and Data Analysis 71 (2014), 849–858.
  <doi:10.1016/j.csda.2013.03.003>
}
