% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictive.R
\name{gfilmmPredictive}
\alias{gfilmmPredictive}
\title{Generalized fiducial predictive distributions}
\usage{
gfilmmPredictive(gfi, newdata)
}
\arguments{
\item{gfi}{a \code{\link{gfilmm}} object}

\item{newdata}{dataframe in which to look for variables with which to predict}
}
\value{
A list with two fields: \code{FPD}, a dataframe containing the 
  simulations, and \code{WEIGHT}, their weight. This is a \code{gfilmm} 
  object.
}
\description{
Simulations of the generalized fiducial predictive 
  distributions.
}
\examples{
gfi <- gfilmm(~ cbind(yield-0.1, yield+0.1), ~ N, ~ block, npk, 2000)
fpd <- gfilmmPredictive(gfi, data.frame(N = c("0","0"), block = c("4","6")))
gfiSummary(fpd)
}
