% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inference.R
\name{gfiConfInt}
\alias{gfiConfInt}
\title{Fiducial confidence interval}
\usage{
gfiConfInt(parameter, fidsamples, conf = 0.95)
}
\arguments{
\item{parameter}{a right-sided formula defining the parameter of interest}

\item{fidsamples}{fiducial samples, the output of \code{\link{gfilogisreg}}}

\item{conf}{confidence level}
}
\value{
The fiducial confidence interval of the parameter.
}
\description{
Fiducial confidence interval of a parameter of interest.
}
\examples{
y <- c(
  0, 0, 0, 1,
  0, 1, 1, 1
)
group <- gl(2, 4)
fidsamples <- gfilogisreg(y ~ 0 + group, N = 500) # (N=500 is not serious)
expit <- function(x) exp(x) / (1+exp(x))
gfiConfInt(~ expit(group1) - expit(group2), fidsamples)
}
