% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3methods.R
\name{print.gformula_continuous_eof}
\alias{print.gformula_continuous_eof}
\title{Print method for objects of class "gformula_continuous_eof"}
\usage{
\method{print}{gformula_continuous_eof}(x, coefficients = FALSE,
  stderrs = FALSE, rmses = FALSE, ...)
}
\arguments{
\item{x}{Object of class "gformula_continuous_eof".}

\item{coefficients}{Logical scalar indicating whether to  print the model coefficients. The default is \code{FALSE}.}

\item{stderrs}{Logical scalar indicating whether to print the standard error of the model coefficients. The default is \code{FALSE}.}

\item{rmses}{Logical scalar indicating whether to print the model root mean square errors (RMSEs). The default is \code{FALSE}.}

\item{...}{Other arguments.}
}
\value{
No value is returned.
}
\description{
Print method for objects of class "gformula_continuous_eof".
}
\examples{
## Estimating the effect of treatment strategies on the mean of a continuous
## end of follow-up outcome
\donttest{
library('Hmisc')
id <- 'id'
time_name <- 't0'
covnames <- c('L1', 'L2', 'A')
outcome_name <- 'Y'
covtypes <- c('categorical', 'normal', 'binary')
histories <- c(lagged)
histvars <- list(c('A', 'L1', 'L2'))
covparams <- list(covmodels = c(L1 ~ lag1_A + lag1_L1 + L3 + t0 +
                                  rcspline.eval(lag1_L2, knots = c(-1, 0, 1)),
                                L2 ~ lag1_A + L1 + lag1_L1 + lag1_L2 + L3 + t0,
                                A ~ lag1_A + L1 + L2 + lag1_L1 + lag1_L2 + L3 + t0))
ymodel <- Y ~ A + L1 + L2 + lag1_A + lag1_L1 + lag1_L2 + L3
intvars <- list('A', 'A')
interventions <- list(list(c(static, rep(0, 7))),
                      list(c(static, rep(1, 7))))
int_descript <- c('Never treat', 'Always treat')
nsimul <- 10000

gform_cont_eof <- gformula_continuous_eof(obs_data = continuous_eofdata,
                                          id = id,
                                          time_name = time_name,
                                          covnames = covnames,
                                          outcome_name = outcome_name,
                                          covtypes = covtypes,
                                          covparams = covparams, ymodel = ymodel,
                                          intvars = intvars,
                                          interventions = interventions,
                                          int_descript = int_descript,
                                          histories = histories, histvars = histvars,
                                          basecovs = c("L3"),
                                          nsimul = nsimul, seed = 1234)
print(gform_cont_eof)
}

}
\seealso{
\code{\link{gformula_continuous_eof}}
}
