% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interventions.R
\name{intfunc}
\alias{intfunc}
\title{Execute Intervention}
\usage{
intfunc(newdf, pool, intervention, intvar, int_time, time_name, t)
}
\arguments{
\item{newdf}{Data table containing the simulated data at time \eqn{t}.}

\item{pool}{Data table containing the simulated data at times before \eqn{t}.}

\item{intervention}{List, whose elements are lists of vectors. Each vector contains a function
implementing a particular intervention on a single variable, optionally
followed by one or more "intervention values" (i.e.,
integers used to specify the treatment regime).}

\item{intvar}{Character string specifying the name of the variable to be intervened on in each round of the simulation.}

\item{int_time}{Vector specifying the time points in which the intervention is applied.}

\item{time_name}{Character string specifying the name of the time variable in \code{pool} and \code{newdf}.}

\item{t}{Integer specifying the current time index.}
}
\value{
No value is returned. The data table \code{newdf} is modified in place.
}
\description{
This internal function executes the intervention of interest on the specified intervention variable
in the data table \code{newdf}.
}
\keyword{internal}
