% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataFunctions.R
\name{sdDiff}
\alias{sdDiff}
\title{sdDiff}
\usage{
sdDiff(x, method = "HALL")
}
\arguments{
\item{x}{vector of datapoints}

\item{method}{Three available methods: \code{"HALL"}, \code{"MAD"} and \code{"SD"}}
}
\value{
a value equal to the estimated standard deviation
}
\description{
sdDiff is a function based on the difference operator (or difference order for HALL method) estimating the time-series standard deviation.
The estimation works for time-series generated by Gaussian
random variables with constant standard deviation and multiple changes in mean.
Three estimators are available:
\itemize{
  \item \code{HALL} : the so-called HALL-estimator of order 3. For more details see: \emph{(1990) Asymptotically optimal difference-based estimation of variance in nonparametric regression. Authors: Hall, Peter and Kay, JW and Titterinton, DM. Biometrika, pages 521--528}
  \item \code{MAD} : the median absolute deviation estimator computed on \code{diff(x)/sqrt(2)} with x the vector of datapoints
  \item \code{SD} : the standard deviation estimator (function sd) computed on \code{diff(x)/sqrt(2)} with x the vector of datapoints
}
}
\examples{
data <- dataGenerator(300, seq(0.1,1,0.1), sample(10), sigma = 2)
sdDiff(data, method = "HALL")
sdDiff(data, method = "MAD")
sdDiff(data, method = "SD")
}
