% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/facet_sample.R
\name{facet_sample}
\alias{facet_sample}
\title{Sample facets when ggplotting.}
\usage{
facet_sample(..., sample_n = c(NA_integer_, NA_integer_),
  seed = NA_integer_)
}
\arguments{
\item{...}{\code{facets}, \code{margins}, etc - see \code{\link[ggplot2]{facet_grid}(...)}.
  The only eliminated parameter is \code{drop} - \code{facet_sample(...)} forces \code{drop = TRUE}

  future: changed default for \code{margin} to show margins
  in the sampled dimension, though \code{margin} may be manually set to \code{FALSE}}

\item{sample_n}{a length 2 integer array, optionally with one value \code{NA_integer_};
  these values are the maximum number of rows (index 1) and columns (index 2) to show
  in \code{\link[ggplot2]{facet_grid}(...)} layout (excluding margins).  If \code{sample_n} exceeds the number of unique
  options in a dimension, \code{facet_sample(...)} will produce a warning.

  a \code{NA_integer_} entry (the default) will provide all the values in that facet, though
  \code{facet_sample(...)} will issue a warning if \code{sample_n} is left as default

  future: a number between 0 and 1 will be treated as the fraction
  of options to be shown (converted to integer by ceiling)}

\item{seed}{the random seed for drawing which rows & columns will be shown;
  by default, this is \code{NA_integer_} and no seed will be set.

  The random number generator is reset for both rows and columns (with an offset) so,
  with \code{seed} provided, changing the number of one dimension to display will not change
  which of the other dimensions are displayed.

  The seed for each dimension may be independently specified with a 2 element array.}
}
\description{
\code{facet_sample(...)} does layout as in \code{\link[ggplot2]{facet_grid}(...)},
  but samples facet(s) vice showing everything.
}
\examples{
  # construct some data:
  sampn <- 10000

  testdata <- data.frame(
    rowcat = paste0("1", sample(LETTERS[1:10], sampn, replace = TRUE)),
    rowcat2 = paste0("2", sample(LETTERS[11:15], sampn, replace = TRUE)),
    colcat = paste0("2", sample(letters[1:10], sampn, replace = TRUE)),
    x = runif(sampn),
    y = runif(sampn)
  )

  p <- ggplot2::ggplot(testdata) + ggplot2::aes(x=x, y=y, color=rowcat2) +
    ggplot2::geom_point()

  # plot the works (not actually recommended)
  \dontrun{p + ggplot2::facet_grid(rowcat ~ colcat)}

  # plot a sample of the row-facets:
  p + facet_sample(rowcat ~ colcat, sample_n = c(3, NA))

  # plot a sample of the column-facets:
  p + facet_sample(rowcat ~ colcat, sample_n = c(NA, 3))

  # plot a sample of all facets:
  p + facet_sample(rowcat ~ colcat, sample_n = c(3, 3))

}
