% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggOceanMaps-package.R
\docType{package}
\name{ggOceanMaps-package}
\alias{ggOceanMaps}
\alias{ggOceanMaps-package}
\title{Plot Data on Oceanographic Maps using ggplot2}
\description{
Uses ggplot2 syntax and shape files to plot research data on 
oceanographic maps anywhere around the globe.
}
\details{
The general map-making function for \pkg{ggOceanMaps} is
\code{\link{basemap}}. This function creates a "canvas" on which research data
can be plotted. The \code{\link{basemap}} function is analogous 
to \code{\link[ggplot2]{ggplot}} function from the \pkg{ggplot2} package. 
Remember to use \code{data = <<NAMEOFDATASET>>} for additional geometries
you plot on \code{basemaps} (\code{basemap(60) + geom_point(data = 
data.frame(lon = 50, lat = 70), aes(x = lon, y = lat))} as an example). As
a shortcut, you may also use qmap(data.frame(lon = c(10, 50), lat = c(60, 70))).
Bathymetry is plotted using the \code{bathymetry} argument.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://mikkovihtakari.github.io/ggOceanMaps/}
  \item Report bugs at \url{https://github.com/MikkoVihtakari/ggOceanMaps/issues}
}

}
\author{
\strong{Maintainer}: Mikko Vihtakari \email{mikko.vihtakari@hi.no} (\href{https://orcid.org/0000-0003-0371-4319}{ORCID}) (Institute of Marine Research)

Other contributors:
\itemize{
  \item Roger Bivand [contributor]
  \item Hadley Wickham [contributor]
  \item Yves Reecht (\href{https://orcid.org/0000-0003-3583-1843}{ORCID}) (Institute of Marine Research) [contributor]
  \item Hadley Wickham [contributor]
  \item Simon O'Hanlon [contributor]
}

}
\keyword{internal}
