% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmx-plots-vpc.R
\name{pmx_plot_vpc}
\alias{pmx_plot_vpc}
\title{VPC plot}
\usage{
pmx_plot_vpc(ctr, type, idv, obs, pi, ci, rug, bin, is.legend, dname,
  filter, strat.facet, facets, strat.color, trans, pmxgpar, labels,
  axis.title, axis.text, ranges, is.smooth, smooth, is.band, band,
  is.draft, draft, is.identity_line, identity_line, scale_x_log10,
  scale_y_log10, color.scales, ...)
}
\arguments{
\item{ctr}{pmx controller}

\item{type}{\code{charcater} can be either percentile or scatter}

\item{idv}{\code{chracater} individual variable}

\item{obs}{\code{pmx_vpc_obs} object observation layer \link{pmx_vpc_obs}}

\item{pi}{\code{pmx_vpc_pi} object percentile layer  \link{pmx_vpc_pi}}

\item{ci}{\code{pmx_vpc_ci} object confidence interval layer  \link{pmx_vpc_ci}}

\item{rug}{\code{pmx_vpc_rug} object rug layer  \link{pmx_vpc_rug}}

\item{bin}{\code{pmx_vpc_bin} object  \link{pmx_vpc_bin}}

\item{is.legend}{\code{logical} if TRUE add legend}

\item{dname}{added for compatibility with other ggPMX plots

\strong{pmx_update parameters}}

\item{filter}{\code{expression} filter which will be applied to plotting data.}

\item{strat.facet}{\code{formula} optional stratification parameter by facetting.
This split plot by strats(each strat in a facet)}

\item{facets}{\code{list} facet_wrap parameters.}

\item{strat.color}{\code{character} optional stratification parameter by grouping.
This will split the plot by group (color) of strat.}

\item{trans}{\code{character} define the transformation to apply on x or y or both variables}

\item{pmxgpar}{a object of class pmx_gpar possibly the output of the

\strong{pmx_gpar: Shared basic graphics parameters}}

\item{labels}{\code{list} list containing plot and/or axis labels: title, subtitle, x , y}

\item{axis.title}{\code{list} containing element_text attributes to customize
the axis title. (similar to ggplot2 axis.title theme)}

\item{axis.text}{\code{list} containing element_text attributes to customize
the axis text (similar to ggplot2 axis.text theme)}

\item{ranges}{\code{list} limits of x/y ranges}

\item{is.smooth}{\code{logical} if set to TRUE add smooth layer}

\item{smooth}{\code{list} geom_smooth graphical/smoothing fun parameters}

\item{is.band}{\code{logical} if TRUE add horizontal band}

\item{band}{\code{list} horizontal band parameters. geom_hline graphical parameters.}

\item{is.draft}{\code{logical} if TRUE add draft layer}

\item{draft}{\code{list} draft layer parameters. geom_text graphical parameters.}

\item{is.identity_line}{\code{logical} if TRUE add an identity line}

\item{identity_line}{\code{list}geom_abline graphical parameters.}

\item{scale_x_log10}{\code{logical} if TRUE use log10 scale for x axis.}

\item{scale_y_log10}{\code{logical} if TRUE use log10 scale for y axis.}

\item{color.scales}{\code{list} define scales parameter in case of strat.color \code{\link{pmx_settings}}}

\item{...}{others graphics parameters passed :
\itemize{
\item \code{\link{pmx_gpar}} internal function to customize shared graphical parameters
\item \code{\link{pmx_vpc}} pmx vpc object.
\item \code{\link{pmx_update}} function.
}

\strong{pmx_vpc parameters}}
}
\value{
ggplot2 or list of ggplot2 objects
}
\description{
VPC plot
}
\details{
You can use \link{pmx_vpc_bin} to set the bin parameters. In case of stratification,
binning can be different for each strat level (case \code{within_strat} equal to FALSE).
}
\examples{
\donttest{
library(ggPMX)

theo_path <- file.path(
  system.file(package = "ggPMX"), "testdata",
  "theophylline"
)
WORK_DIR <- file.path(theo_path, "Monolix")
input_file <- file.path(theo_path, "data_pk.csv")
vpc_file <- file.path(theo_path, "sim.csv")

ctr <- pmx_mlx(
  config = "standing",
  directory = WORK_DIR,
  input = input_file,
  dv = "Y",
  dvid = "dvid",
  cats = c("SEX"),
  conts = c("WT0", "AGE0"),
  strats = "STUD",
  settings = pmx_settings(
    use.labels=TRUE,
    cats.labels=list(
      SEX=c("0"="Male","1"="Female")
    )
  ),
  sim = pmx_sim(
    file = vpc_file,
    irun ="rep",
    idv="TIME"
  )
)


ctr \%>\% pmx_plot_vpc(
  strat.facet="SEX",
  facets=list(nrow=2),
  type="percentile",
  is.draft = FALSE,
  pi = pmx_vpc_pi(interval = c(0.1,0.9),
              median=list(color="green"),
              extreme= list(color="green")),
  obs = pmx_vpc_obs(color="blue",shape=18,size=2),
  ci = pmx_vpc_ci(interval = c(0.1,0.9),
              median=list(fill="pink")),
  bin=pmx_vpc_bin("kmeans",n=5)
)

ctr \%>\% 
  pmx_plot_vpc(bin= pmx_vpc_bin(
     style = "fixed",
     fixedBreaks=c(-10,2, 5, 10,15,50))
  )

# example with legend 

ctr \%>\% pmx_plot_vpc(
  is.legend = TRUE,
  pi = pmx_vpc_pi(interval=c(0.02,0.98),median = list(linetype="dotted")),
  ci = pmx_vpc_ci(interval = c(0.05,0.95),median=list(fill="red"))
)

}
}
\seealso{
Other vpc: \code{\link{pmx_vpc_bin}},
  \code{\link{pmx_vpc_ci}}, \code{\link{pmx_vpc_obs}},
  \code{\link{pmx_vpc_pi}}, \code{\link{pmx_vpc_rug}},
  \code{\link{pmx_vpc}}
}
\concept{vpc}
