% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmx-plots-distibution.R
\name{eta_distribution_plot}
\alias{eta_distribution_plot}
\alias{pmx_plot_eta_box}
\alias{pmx_plot_eta_hist}
\title{Eta distribution plots}
\usage{
eta_distribution_plot(
  jitter,
  type,
  dname,
  is.shrink,
  shrink,
  is.jitter,
  histogram,
  filter,
  strat.facet,
  facets,
  strat.color,
  trans,
  pmxgpar,
  labels,
  axis.title,
  axis.text,
  ranges,
  is.smooth,
  smooth,
  is.band,
  band,
  is.draft,
  draft,
  is.identity_line,
  identity_line,
  scale_x_log10,
  scale_y_log10,
  color.scales,
  ...
)

pmx_plot_eta_box(ctr, ...)

pmx_plot_eta_hist(ctr, ...)
}
\arguments{
\item{jitter}{list set jitter parameter}

\item{type}{box for boxplot or histogram}

\item{dname}{name of dataset to be used}

\item{is.shrink}{\code{logical} if TRUE add shrinkage layer}

\item{shrink}{\code{list} parameters to control shrinkage, must contain "fun"}

\item{is.jitter}{\code{logical} if TRUE add jitter operator for points}

\item{histogram}{\code{list} histogram graphical parameters

\strong{pmx_update parameters}}

\item{filter}{\code{expression} filter which will be applied to plotting data.}

\item{strat.facet}{\code{formula} optional stratification parameter by facetting.
This split plot by strats(each strat in a facet)}

\item{facets}{\code{list} facet_wrap parameters.}

\item{strat.color}{\code{character} optional stratification parameter by grouping.
This will split the plot by group (color) of strat.}

\item{trans}{\code{character} define the transformation to apply on x or y or both variables}

\item{pmxgpar}{a object of class pmx_gpar possibly the output of the

\strong{pmx_gpar: Shared basic graphics parameters}}

\item{labels}{\code{list} list containing plot and/or axis labels: title, subtitle, x , y}

\item{axis.title}{\code{list} containing element_text attributes to customize
the axis title. (similar to ggplot2 axis.title theme)}

\item{axis.text}{\code{list} containing element_text attributes to customize
the axis text (similar to ggplot2 axis.text theme)}

\item{ranges}{\code{list} limits of x/y ranges}

\item{is.smooth}{\code{logical} if set to TRUE add smooth layer}

\item{smooth}{\code{list} geom_smooth graphical/smoothing fun parameters}

\item{is.band}{\code{logical} if TRUE add horizontal band}

\item{band}{\code{list} horizontal band parameters. geom_hline graphical parameters.}

\item{is.draft}{\code{logical} if TRUE add draft layer}

\item{draft}{\code{list} draft layer parameters. geom_text graphical parameters.}

\item{is.identity_line}{\code{logical} if TRUE add an identity line}

\item{identity_line}{\code{list}geom_abline graphical parameters.}

\item{scale_x_log10}{\code{logical} if TRUE use log10 scale for x axis.}

\item{scale_y_log10}{\code{logical} if TRUE use log10 scale for y axis.}

\item{color.scales}{\code{list} define scales parameter in case of strat.color \code{\link{pmx_settings}}}

\item{...}{others graphics parameters passed :
\itemize{
\item \code{\link{pmx_gpar}} internal function to customize shared graphical parameters
\item \code{\link{distrib}} generic object for distribution plots (histogram/boxplot).
\item \code{\link{pmx_update}} function.
}

\strong{distrib parameters}}

\item{ctr}{pmx controller}
}
\value{
ggplot2 object
}
\description{
Eta distribution plots

Eta Distribution boxplot

Eta Distribution histogram plot
}
\examples{
\donttest{
# *************** basic use ***************** ------

ctr <- theophylline()
## boxplot variation
p <- ctr \%>\% pmx_plot_eta_box()
## histogram variation
p <- ctr \%>\% pmx_plot_eta_hist()

# update graphical parameter  ----------------------

## add jitter
ctr \%>\%
  pmx_plot_eta_hist(is.jitter = TRUE, jitter = list(alpha = 0.4, color = "red"))

## remove shrinkage
ctr \%>\%
  pmx_plot_eta_hist(is.shrink = FALSE)

## update histogram graphical parameters
ctr \%>\%
  pmx_plot_eta_hist(
    histogram = list(
      color = NA,
      position = "fill",
      binwidth = 1 / 100
    )
  )



# stratification  ----------------------------------

## categorical stratification color parameter
ctr \%>\% pmx_plot_eta_hist(is.jitter = TRUE, strat.facet = ~STUD, strat.color = ~SEX)
  
## categorical stratification facetting
ctr \%>\% pmx_plot_eta_hist(strat.facet = ~SEX)

## using formula categorical stratification facetting
ctr \%>\% pmx_plot_eta_hist(
  strat.facet = STUD ~ SEX,
  shrink = pmx_shrink(hjust = 0.5)
)

# subsetting  --------------------------------------

## select a set of random effect
ctr \%>\% pmx_plot_eta_hist(filter = EFFECT \%in\% c("ka", "Cl"))
## filter and stratify by facets
ctr \%>\% pmx_plot_eta_hist(
  filter = EFFECT \%in\% c("ka", "Cl"), strat.facet = ~SEX
)
ctr \%>\% pmx_plot_eta_hist(
  filter = EFFECT \%in\% c("ka", "Cl"), strat.facet = ~SEX
)
}
}
\concept{eta_distribution_plot}
