% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_roc.R
\name{gg_roc.rfsrc}
\alias{gg_roc.rfsrc}
\alias{gg_roc}
\alias{gg_roc.randomForest}
\title{ROC (Receiver operator curve) data from a classification random forest.}
\usage{
\method{gg_roc}{rfsrc}(object, which_outcome, oob, ...)
}
\arguments{
\item{object}{an \code{\link[randomForestSRC]{rfsrc}} classification object}

\item{which_outcome}{select the classification outcome of interest.}

\item{oob}{use oob estimates (default TRUE)}

\item{...}{extra arguments (not used)}
}
\value{
\code{gg_roc} \code{data.frame} for plotting ROC curves.
}
\description{
The sensitivity and specificity of a randomForest classification object.
}
\examples{
## ------------------------------------------------------------
## classification example
## ------------------------------------------------------------
## -------- iris data
rfsrc_iris <- rfsrc(Species ~ ., data = iris)

# ROC for setosa
gg_dta <- gg_roc(rfsrc_iris, which_outcome=1)
plot(gg_dta)

# ROC for versicolor
gg_dta <- gg_roc(rfsrc_iris, which_outcome=2)
plot(gg_dta)

# ROC for virginica
gg_dta <- gg_roc(rfsrc_iris, which_outcome=3)
plot(gg_dta)

## -------- iris data
rf_iris <- randomForest::randomForest(Species ~ ., data = iris)

# ROC for setosa
gg_dta <- gg_roc(rf_iris, which_outcome=1)
plot(gg_dta)

# ROC for versicolor
gg_dta <- gg_roc(rf_iris, which_outcome=2)
plot(gg_dta)

# ROC for virginica
gg_dta <- gg_roc(rf_iris, which_outcome=3)
plot(gg_dta)


}
\seealso{
\code{\link{plot.gg_roc}} \code{\link[randomForestSRC]{rfsrc}}
\code{\link[randomForest]{randomForest}}
}
