% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.gg_minimal_vimp.R
\name{plot.gg_minimal_vimp}
\alias{plot.gg_minimal_vimp}
\title{Plot a \code{\link{gg_minimal_vimp}} object for comparing the Minimal
Depth and VIMP variable rankings.}
\usage{
\method{plot}{gg_minimal_vimp}(x, nvar, lbls, ...)
}
\arguments{
\item{x}{\code{\link{gg_minimal_depth}} object created from a
\code{\link[randomForestSRC]{var.select}}
object}

\item{nvar}{should the figure be restricted to a subset of the points.}

\item{lbls}{a vector of alternative variable names.}

\item{...}{optional arguments (not used)}
}
\value{
\code{ggplot} object
}
\description{
Plot a \code{\link{gg_minimal_vimp}} object for comparing the Minimal
Depth and VIMP variable rankings.
}
\examples{
\dontrun{
## Examples from RFSRC package...
## ------------------------------------------------------------
## classification example
## ------------------------------------------------------------
## -------- iris data
## You can build a randomForest
rfsrc_iris <- rfsrc(Species ~ ., data = iris)
varsel_iris <- var.select(rfsrc_iris)

# Get a data.frame containing minimaldepth measures
gg_dta<- gg_minimal_vimp(varsel_iris)

# Plot the gg_minimal_depth object
plot(gg_dta)

## ------------------------------------------------------------
## Regression example
## ------------------------------------------------------------
## -------- air quality data
rfsrc_airq <- rfsrc(Ozone ~ ., data = airquality, na.action = "na.impute")
varsel_airq <- var.select(rfsrc_airq)

# Get a data.frame containing error rates
gg_dta<- gg_minimal_vimp(varsel_airq)

# Plot the gg_minimal_vimp object
plot(gg_dta)

## -------- Boston data
data(Boston, package="MASS")
rfsrc_boston <- randomForestSRC::rfsrc(medv~., Boston)

varsel_boston <- var.select(rfsrc_boston)

# Get a data.frame containing error rates
gg_dta<- gg_minimal_vimp(varsel_boston)

# Plot the gg_minimal_vimp object
plot(gg_dta)

## -------- mtcars data
rfsrc_mtcars <- rfsrc(mpg ~ ., data = mtcars)
varsel_mtcars <- var.select(rfsrc_mtcars)

# Get a data.frame containing error rates
gg_dta<- gg_minimal_vimp(varsel_mtcars)

# Plot the gg_minimal_vimp object
plot(gg_dta)

## ------------------------------------------------------------
## Survival example
## ------------------------------------------------------------
## -------- veteran data
## randomized trial of two treatment regimens for lung cancer
data(veteran, package = "randomForestSRC")
rfsrc_veteran <- rfsrc(Surv(time, status) ~ ., data = veteran, ntree = 100)
varsel_veteran <- var.select(rfsrc_veteran)

gg_dta <- gg_minimal_vimp(varsel_veteran)
plot(gg_dta)

## -------- pbc data
# We need to create this dataset
data(pbc, package = "randomForestSRC",) 
# For whatever reason, the age variable is in days... makes no sense to me
for (ind in seq_len(dim(pbc)[2])) {
 if (!is.factor(pbc[, ind])) {
   if (length(unique(pbc[which(!is.na(pbc[, ind])), ind])) <= 2) {
     if (sum(range(pbc[, ind], na.rm = TRUE) == c(0, 1)) == 2) {
       pbc[, ind] <- as.logical(pbc[, ind])
     }
   }
 } else {
   if (length(unique(pbc[which(!is.na(pbc[, ind])), ind])) <= 2) {
     if (sum(sort(unique(pbc[, ind])) == c(0, 1)) == 2) {
       pbc[, ind] <- as.logical(pbc[, ind])
     }
     if (sum(sort(unique(pbc[, ind])) == c(FALSE, TRUE)) == 2) {
       pbc[, ind] <- as.logical(pbc[, ind])
     }
   }
 }
 if (!is.logical(pbc[, ind]) &
     length(unique(pbc[which(!is.na(pbc[, ind])), ind])) <= 5) {
   pbc[, ind] <- factor(pbc[, ind])
 }
}
#Convert age to years
pbc$age <- pbc$age / 364.24

pbc$years <- pbc$days / 364.24
pbc <- pbc[, -which(colnames(pbc) == "days")]
pbc$treatment <- as.numeric(pbc$treatment)
pbc$treatment[which(pbc$treatment == 1)] <- "DPCA"
pbc$treatment[which(pbc$treatment == 2)] <- "placebo"
pbc$treatment <- factor(pbc$treatment)
dta_train <- pbc[-which(is.na(pbc$treatment)), ]
# Create a test set from the remaining patients
pbc_test <- pbc[which(is.na(pbc$treatment)), ]

#========
# build the forest:
rfsrc_pbc <- randomForestSRC::rfsrc(
  Surv(years, status) ~ .,
 dta_train,
 nsplit = 10,
 na.action = "na.impute",
 forest = TRUE,
 importance = TRUE,
 save.memory = TRUE
)

varsel_pbc <- var.select(rfsrc_pbc)

gg_dta <- gg_minimal_vimp(varsel_pbc)
plot(gg_dta)
}

}
\seealso{
\code{\link{gg_minimal_vimp}}
\code{\link[randomForestSRC]{var.select}}
}
