% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout-stack-.R
\name{stack_layout}
\alias{stack_layout}
\alias{ggstack}
\title{Put plots horizontally or vertically}
\usage{
stack_layout(
  data,
  direction = NULL,
  sizes = NA,
  ...,
  guides = waiver(),
  theme = NULL
)

ggstack(
  data,
  direction = NULL,
  sizes = NA,
  ...,
  guides = waiver(),
  theme = NULL
)
}
\arguments{
\item{data}{A numeric or character vector, a data frame, or a matrix.}

\item{direction}{A string of \code{"horizontal"} or \code{"vertical"}, indicates the
direction of the stack layout.}

\item{sizes}{A numeric or \link[grid:unit]{unit} object of length \code{3} indicates
the relative widths (\code{direction = "horizontal"}) / heights (\code{direction = "vertical"}).}

\item{...}{<\link[rlang:dyn-dots]{dyn-dots}> A list of plots, ususally the
ggplot object. Use \code{NULL} to indicate an empty spacer.}

\item{guides}{A string containing one or more of \code{"t"}, \code{"l"}, \code{"b"}, and \code{"r"} indicates which side of guide legends should be collected. If \code{NULL}, no guide legends will be collected. If \code{\link[ggplot2:waiver]{waiver()}}, it will inherit from the parent layout}

\item{theme}{A \code{\link[ggplot2:theme]{theme()}} used to render the \code{guides},
\code{title}, \code{subtitle}, \code{caption}, \code{margins}, \code{patch.title}, \code{panel.border}, and
\code{background}. If \code{NULL} (default), will inherit from the parent \code{layout}.}
}
\value{
A \code{StackLayout} object.
}
\description{
\code{ggstack} is an alias of \code{stack_layout}.
}
\examples{
ggstack(matrix(rnorm(100L), nrow = 10L)) + align_dendro()
}
