% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/position-quasirandom.R
\name{position_quasirandom}
\alias{position_quasirandom}
\title{Violin point-style plots to show overlapping points. x must be discrete.}
\usage{
position_quasirandom(width = NULL, varwidth = FALSE, bandwidth = 0.5,
  nbins = NULL, method = "quasirandom", groupOnX = NULL,
  dodge.width = 0)
}
\arguments{
\item{width}{the maximum amount of spread (default: 0.4)}

\item{varwidth}{vary the width by the relative size of each group}

\item{bandwidth}{the bandwidth adjustment to use when calculating density
Smaller numbers (< 1) produce a tighter "fit". (default: 0.5)}

\item{nbins}{the number of bins used when calculating density (has little effect with quasirandom/random distribution)}

\item{method}{the method used for distributing points (quasirandom, pseudorandom, smiley or frowney)}

\item{groupOnX}{should jitter be added to the x axis if TRUE or y axis if FALSE (the default NULL causes the function to guess which axis is the categorical one based on the number of unique entries in each)}

\item{dodge.width}{Amount by which points from different aesthetic groups will be dodged. This requires that one of the aesthetics is a factor.}
}
\description{
Violin point-style plots to show overlapping points. x must be discrete.
}
\examples{

  ggplot2::qplot(class, hwy, data = ggplot2::mpg, geom='quasirandom')
  # Generate fake data
  distro <- data.frame(
    'variable'=rep(c('runif','rnorm'),each=100),
    'value'=c(runif(100, min=-3, max=3), rnorm(100))
  )
  ggplot2::qplot(variable, value, data = distro, geom = 'quasirandom')
  ggplot2::qplot(variable, value, data = distro) + geom_quasirandom(width=0.1)

}
\seealso{
\code{\link[vipor]{offsetX}}

Other position.adjustments: \code{\link{position_beeswarm}}
}

