#' A blue colour
#'
#' @description A blue colour derived from `viridisLite::mako(9)[5]`
#'
#' @return A character vector.
#' @export
#'
#' @examples
#' scales::show_col(blue)
blue <- "#357BA2"

#' A teal colour
#'
#' @description A teal colour.
#'
#' @return A character vector.
#' @export
#'
#' @examples
#' scales::show_col(teal)
teal <- "#0095A8"

#' A orange colour
#'
#' @description A orange colour.
#'
#' @return A character vector.
#' @export
#'
#' @examples
#' scales::show_col(orange)
orange <- "#ffa600"

#' A navy colour
#'
#' @description A navy colour.
#'
#' @return A character vector.
#' @export
#'
#' @examples
#' scales::show_col(navy)
navy <- "#003f5c"

#' The `light_mode_*` theme colours
#'
#' @description A vector of colours used in the `light_mode_*` themes.
#'
#' @return A character vector.
#' @export
#'
#' @examples
#' scales::show_col(lightness)
lightness <- c("#F6F8FA", "#121B24", "#FFFFFF")

#' The `grey_mode_*` theme colours
#'
#' @description A vector of colours used in the `grey_mode_*` themes.
#'
#' @return A character vector.
#' @export
#'
#' @examples
#' scales::show_col(greyness)
greyness <- c("#F6F8FA", "#121B24", "#fCFDFE")

#' The `dark_mode_*` theme colours
#'
#' @description A vector of colours used in the `dark_mode_*` themes.
#'
#' @return A character vector.
#' @export
#'
#' @examples
#' scales::show_col(darkness)
darkness <- c("#00040a", "#C8D7DF", "#050D1B")
