% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggcoverage.R
\name{ggcoverage}
\alias{ggcoverage}
\title{Create Coverage Plot.}
\usage{
ggcoverage(
  data,
  region = "chr14:21,677,306-21,737,601",
  gtf.gr = NULL,
  extend = 2000,
  gene.name = "HNRNPC",
  gene.name.type = c("gene_name", "gene_id"),
  single.nuc = FALSE,
  mapping = NULL,
  color = NULL,
  rect.color = NA,
  facet.key = "Type",
  facet.order = NULL,
  facet.color = NULL,
  group.key = "Group",
  range.size = 3,
  range.position = c("in", "out"),
  plot.space = 0.2,
  mark.region = NULL,
  mark.color = "grey",
  mark.alpha = 0.5,
  show.mark.label = TRUE,
  mark.label.size = 4
)
}
\arguments{
\item{data}{Coverage dataframe loaded by \code{\link{LoadTrackFile}}.}

\item{region}{Region used to create coverage plot, eg: chr14:21,677,306-21,737,601 or chr14:21,677,306.
Default: NULL.}

\item{gtf.gr}{Granges object of GTF, created with \code{\link{import.gff}}. Default: NULL.}

\item{extend}{Extend length of \code{region}. Default: 2000.}

\item{gene.name}{The name of gene. Default: HNRNPC.}

\item{gene.name.type}{Gene name type (filed of \code{gtf.gr}), chosen from gene_name and gene_id.
Default: gene_name.}

\item{single.nuc}{Logical value, whether to visualize at single nucleotide level. Default: FALSE.}

\item{mapping}{Set of aesthetic mappings created by \code{aes} or \code{aes_}. Default: NULL.}

\item{color}{Track color. Default: NULL (select automatically).}

\item{rect.color}{The color of every bin. Default: NA.}

\item{facet.key}{Sample type key to create coverage plot. Default: Type.}

\item{facet.order}{The order of Coverage plot. Default: NULL.}

\item{facet.color}{The color of sample text. Default: NULL (select automatically).}

\item{group.key}{Group of samples. Default: NULL.}

\item{range.size}{The label size of range text, used when \code{range.position} is in. Default: 3.}

\item{range.position}{The position of y axis range, chosen from in (move y axis in the plot) and
out (normal y axis). Default: in.}

\item{plot.space}{The space between every facet. Default: 0.2.}

\item{mark.region}{Mark region on the plot. Default: NULL.}

\item{mark.color}{The color of marked region. Default: "grey".}

\item{mark.alpha}{The alpha of marked region. Default: 0.5.}

\item{show.mark.label}{Logical value, whether to show mark label (use label column in \code{mark.region}). Default: TRUE.}

\item{mark.label.size}{The label size of mark label. Default: 4.}
}
\value{
A ggplot2 object.
}
\description{
Create Coverage Plot.
}
\examples{
library(ggcoverage)
library(utils)
library(rtracklayer)
meta.file <- system.file("extdata", "RNA-seq", "meta_info.csv", package = "ggcoverage")
sample.meta <- utils::read.csv(meta.file)
# track folder
track.folder <- system.file("extdata", "RNA-seq", package = "ggcoverage")
# load bigwig file
track.df <- LoadTrackFile(
  track.folder = track.folder, format = "bw",
  meta.info = sample.meta
)
gtf.file <- system.file("extdata", "used_hg19.gtf", package = "ggcoverage")
gtf.gr <- rtracklayer::import.gff(con = gtf.file, format = "gtf")
ggcoverage(data = track.df, color = "auto", range.position = "out")
}
