% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{hdi}
\alias{hdi}
\title{Highest density interval}
\usage{
hdi(x, prob = 0.95, warn = TRUE)
}
\arguments{
\item{x}{Numeric vector of a distribution of data, typically a posterior
sample}

\item{prob}{Width of the interval from some distribution. Defaults to \code{0.95}.}

\item{warn}{Option to turn off multiple sample warning message Must be in the
range of \code{[0,1]}.}
}
\value{
Numeric range
}
\description{
This is a function that will calculate the highest density interval from a
posterior sample.
}
\details{
The default is to calcualte the highest 95 percent interval. It can be used
with any numeric vector instead of having to use one of the specific MCMC
classes. This function has been adapted from John K. Kruschke (2011). Doing
Bayesian Data Analaysis: A Tutorial with R and BUGS.
}
\examples{
x <- qnorm(seq(1e-04, .9999, length.out=1001))
hdi_95 <- hdi(x, .95)
hdi_50 <- hdi(x, .50)

hist(x, br=50)
abline(v=hdi_95, col="red")
abline(v=hdi_50, col="green")

x <- exp(seq(pi * (1 - (1/16)), pi, len = 1000))
x <- c(x, rev(x)[-1])
x <- c(-x, x)
plot(sort(x), type="l")
plot(density(x, adjust=0.25))
abline(v=hdi(x, p=.49), col=2)
abline(v=hdi(x, p=.50), col=3)
}
