% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis.R
\name{gelman}
\alias{gelman}
\alias{hgelman}
\title{Potential scale reduction factor}
\usage{
gelman(x, hyper = FALSE, start = 1, end = NA, confidence = 0.95,
  transform = TRUE, autoburnin = FALSE, multivariate = TRUE,
  split = TRUE, subchain = FALSE, nsubchain = 3, digits = 2,
  verbose = FALSE, ...)

hgelman(x, start = 1, end = NA, confidence = 0.95,
  transform = TRUE, autoburnin = FALSE, split = TRUE,
  subchain = FALSE, nsubchain = 3, digits = 2, verbose = FALSE,
  ...)
}
\arguments{
\item{x}{posterior samples}

\item{hyper}{a Boolean switch, indicating posterior samples are from
hierarchical modeling}

\item{start}{start iteration}

\item{end}{end iteration}

\item{confidence}{confident inteval}

\item{transform}{turn on transform}

\item{autoburnin}{turn on auto burnin}

\item{multivariate}{multivariate Boolean switch}

\item{split}{split whether split mcmc chains; When split is TRUE, the function
doubles the number of chains by spliting into 1st and 2nd halves.}

\item{subchain}{whether only calculate a subset of chains}

\item{nsubchain}{indicate how many chains in a subset}

\item{digits}{print out how many digits}

\item{verbose}{print more information}

\item{...}{arguments passing to \code{coda} gelman.diag.}
}
\description{
\code{gelman} function calls the function, \code{gelman.diag} in the
\pkg{coda} package to calculates PSRF.
}
\examples{
\dontrun{
rhat1 <- hgelman(hsam); rhat1
rhat2 <- hgelman(hsam, end = 51); rhat2
rhat3 <- hgelman(hsam, confidence = .90); rhat3
rhat4 <- hgelman(hsam, transform = FALSE); rhat4
rhat5 <- hgelman(hsam, autoburnin = TRUE); rhat5
rhat6 <- hgelman(hsam, split = FALSE); rhat6
rhat7 <- hgelman(hsam, subchain = TRUE); rhat7
rhat8 <- hgelman(hsam, subchain = TRUE, nsubchain = 4);
rhat9 <- hgelman(hsam, subchain = TRUE, nsubchain = 4,
digits = 1, verbose = TRUE);

hat1 <- gelman(hsam[[1]], multivariate = FALSE); hat1
hat2 <- gelman(hsam[[1]], hyper = TRUE, verbose = TRUE); hat2
hat3 <- gelman(hsam, hyper = TRUE, verbose = TRUE); hat3
hat4 <- gelman(hsam, multivariate = TRUE, verbose = FALSE);
hat5 <- gelman(hsam, multivariate = FALSE, verbose = FALSE);
hat6 <- gelman(hsam, multivariate = FALSE, verbose = TRUE);
hat7 <- gelman(hsam, multivariate = T, verbose = TRUE);
}
}
