% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moderator_pattern.R
\name{rprs_values}
\alias{rprs_values}
\title{Calculate representative values of a vector}
\usage{
rprs_values(x, values = "meansd")
}
\arguments{
\item{x}{A numeric vector.}

\item{values}{Character vector, naming a pattern for which representative values
should be calculcated.
       \describe{
         \item{\code{"minmax"}}{(default) minimum and maximum values (lower and upper bounds) of the moderator are used to plot the interaction between independent variable and moderator.}
         \item{\code{"meansd"}}{uses the mean value of the moderator as well as one standard deviation below and above mean value to plot the effect of the moderator on the independent variable.}
         \item{\code{"zeromax"}}{is similar to the \code{"minmax"} option, however, \code{0} is always used as minimum value for the moderator. This may be useful for predictors that don't have an empirical zero-value, but absence of moderation should be simulated by using 0 as minimum.}
         \item{\code{"quart"}}{calculates and uses the quartiles (lower, median and upper) of the moderator value, \emph{including} minimum and maximum value.}
         \item{\code{"quart2"}}{calculates and uses the quartiles (lower, median and upper) of the moderator value, \emph{excluding} minimum and maximum value.}
         \item{\code{"all"}}{uses all values of the moderator variable. Note that this option only applies to \code{type = "eff"}, for numeric moderator values.}
       }}
}
\value{
A numeric vector of length two or three, representing the required
  values from \code{x}, like minimum/maximum value or mean and +/- 1 SD.
}
\description{
This function calculates representative values of a vector,
  like minimum/maximum values or lower, median and upper quartile etc.,
  which can be used for numeric vectors to plot marginal effects at these
  representative values.
}
\examples{
data(efc)
rprs_values(efc$c12hour)
rprs_values(efc$c12hour, "quart2")

}
