% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_fields.r
\docType{data}
\name{GeomFields}
\alias{GeomFields}
\alias{geom_fields}
\title{Arrows depicting a vector field}
\format{
An object of class \code{GeomFields} (inherits from \code{GeomSegment}, \code{Geom}, \code{ggproto}, \code{gg}) of length 8.
}
\usage{
GeomFields

geom_fields(
  mapping = NULL,
  data = NULL,
  stat = "fields",
  position = "identity",
  na.rm = FALSE,
  show.legend = NA,
  max_radius = ggplot2::unit(0.5, "cm"),
  .angle_correction = angle_correction,
  arrow = grid::arrow(length = ggplot2::unit(0.2, "cm")),
  inherit.aes = TRUE,
  ...
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{Can be one of four things:
\itemize{
\item \code{NULL}: in that case data from the parent \link[ggplot2:ggplot]{ggplot} call is
inherited.
\item \code{data.frame}: you need to assign the \code{x} and \code{y} aesthetics.
\item \link[sf:st_as_sf]{sf object}: it should contain a \code{geometry} column with only \code{POINT} geometries.
\item \link[stars:st_as_stars]{stars object}: it will be converted automatically to an \code{sf} object.
}}

\item{stat}{The statistical transformation to use on the data for this layer. By default it is
set to \code{GeomFields()} (\code{"fields"}).}

\item{position}{Position adjustment, either as a string naming the adjustment
(e.g. \code{"jitter"} to use \code{position_jitter}), or the result of a call to a
position adjustment function. Use the latter if you need to change the
settings of the adjustment.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{max_radius}{Maximum radius to which the \code{radius} aesthetic is scaled in the plot.
You can use absolute ("e.g., "cm", "in", "pt") and relative ("npc") \link[ggplot2:reexports]{units} to set
its value. Default is \verb{0.5 cm}.}

\item{.angle_correction}{Function to correct the angle in the aesthetics for the projection and/or
aspect ratio used in the plot. When set to \code{NULL} the angle is not corrected and is treated as the angle
in the final plot. A custom function can be provided which should accept at least three arguments
(\code{data}, \code{panel_params} and \code{coord}). See \code{\link[=angle_correction]{angle_correction()}} and \code{vignette("angle_correction")} for
more details.}

\item{arrow}{specification for arrow heads, as created by \code{\link[grid:arrow]{grid::arrow()}}.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}
}
\value{
A \link[ggplot2:layer]{layer} which can be added to a \link[ggplot2:ggplot]{ggplot}.
}
\description{
Visualise vector fields (such as, electric/magnetic fields, wind speed, or water currents)
with arrows as a layer in a \link[ggplot2:ggplot]{ggplot}.
}
\details{
Adds a layer with vector fields to a \link[ggplot2:ggplot]{ggplot}. In order to achieve this
two special aesthetic are required: \code{radius} and \code{angle}.
}
\section{Aesthetics}{

\itemize{
\item \strong{\code{geometry|x}}: Either a \code{geometry} column or \code{x} coordinate.
In case of \code{geometry} the column should be of class \link[sf:sfc]{sf::sfc_POINT}.
In case of \code{x}, it should be a \code{numeric} \code{vector}, and the aesthetic
\code{y} needs to be specified as well. It specifies the location of
the origin of each vector.
\item \strong{\code{radius}}: This aesthetic will be used to scale the radius of the
vector arrows in the field you wish to display. The maximum radius of the
arrows is given by parameter \code{max_radius}. See \code{vignette("radius_aes")} for
more details.
\item \strong{\code{angle}}: This aesthetic represent the angles of the vectors in your
field in radians. Contrary to the mathematical definition, an angle of 0 radians will
point upwards (instead of to the right). This was chosen such because in most geographical
applications an angle of zero degrees points Northwards. Before plotting these angles are
corrected by the function passed to the \code{.angle_correction} argument.
See \verb{vignette("angle_corrections)} for more details.
\item \code{y}: This aesthetic needs to be used in combination with the \code{x} aesthetic.
It needs to be a \code{numeric} \code{vector}.
\item \code{fill}: See \code{vignette("ggplot2-specs", "ggplot2")}
\item \code{colour}: See \code{vignette("ggplot2-specs", "ggplot2")}
\item \code{linetype}: See \code{vignette("ggplot2-specs", "ggplot2")}
\item \code{linewidth}: See \code{vignette("ggplot2-specs", "ggplot2")}
\item \code{alpha}: A variable to control the opacity of an element.
}
}

\examples{
data(seawatervelocity)

if (requireNamespace("ggplot2") && requireNamespace("stars") &&
      requireNamespace("scales")) {
  library(ggplot2)
  library(stars)
  
  sw_df <- as.data.frame(seawatervelocity)
  ggplot(sw_df, aes(x = x, y = y, radius = as.numeric(v), angle = as.numeric(angle))) +
    geom_fields(max_radius = unit(0.5, "cm"), na.rm = TRUE)
  
  ggplot() +
    geom_fields(data    = seawatervelocity,
                mapping = aes(radius = as.numeric(v),
                              angle  = as.numeric(angle),
                              col    = as.numeric(v)),
                max_radius = unit(0.5, "cm")) +
    scale_colour_viridis_c()
}
}
\author{
Pepijn de Vries
}
\keyword{datasets}
