% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gf_functions.R
\name{gf_linerange}
\alias{gf_linerange}
\alias{gf_pointrange}
\title{Formula interface to geom_linerange() and geom_pointrange()}
\usage{
gf_linerange(object = NULL, gformula = NULL, data = NULL,
  geom = "linerange", stat = "identity", position = "identity",
  show.legend = NA, show.help = NULL, inherit = TRUE,
  environment = parent.frame(), xlab, ylab, title, subtitle, caption, ...)

gf_pointrange(object = NULL, gformula = NULL, data = NULL,
  geom = "pointrange", stat = "identity", position = "identity",
  show.legend = NA, show.help = NULL, inherit = TRUE,
  environment = parent.frame(), xlab, ylab, title, subtitle, caption, ...)
}
\arguments{
\item{object}{When chaining, this holds an object produced in the earlier portions
of the chain.  Most users can safely ignore this argument.
See details and examples.}

\item{gformula}{A formula with shape \code{ymin + ymax ~ x}.
Faceting can be achieved by including \code{|} in the formula.}

\item{data}{A data frame with the variables to be plotted.}

\item{geom}{A character string naming the geom used to make the layer.}

\item{stat}{A character string naming the stat used to make the layer.}

\item{position}{Either a character string naming the position function used
for the layer or a position object returned from a call to a position function.}

\item{show.legend}{A logical indicating whether this layer should be included in
the legends.  \code{NA}, the default, includes layer in the legends if any
of the attributes of the layer are mapped.}

\item{show.help}{If \code{TRUE}, display some minimal help.}

\item{inherit}{A logical indicating whether default attributes are inherited.}

\item{environment}{An environment in which to look for variables not found in \code{data}.}

\item{xlab}{Label for x-axis. See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{ylab}{Label for y-axis. See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{title}{Title, sub-title, and caption for the plot.
See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{subtitle}{Title, sub-title, and caption for the plot.
See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{caption}{Title, sub-title, and caption for the plot.
See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{...}{Additional arguments.  Typically these are
(a) ggplot2 aesthetics to be set with \code{attribute = value},
(b) ggplot2 aesthetics to be mapped with \code{attribute = ~expression}, or
(c) attributes of the layer as a whole, which are set with \code{attribute = value}.
Available attributes include
\code{alpha}, \code{color}, \code{group}, \code{linetype}, \code{size}}
}
\value{
a gg object
}
\description{
Formula interface to geom_linerange() and geom_pointrange()
}
\details{
Positional aesthetics are specified using the formula in \code{gformula}.
Setting and mapping of additional attributes can be done through the
use of additional arguments.
Attributes can be set can be set using arguments of the form \code{attribute = value} or
mapped using arguments of the form \code{attribute = ~ expression}.

In formulas of the form \code{A | B}, \code{B} will be used to form facets using
\code{\link[=facet_wrap]{facet_wrap()}} or \code{\link[=facet_grid]{facet_grid()}}.
This provides an alternative to
\code{\link[=gf_facet_wrap]{gf_facet_wrap()}} and
\code{\link[=gf_facet_grid]{gf_facet_grid()}} that is terser and may feel more familiar to users
of \pkg{lattice}.

Evaluation of the \pkg{ggplot2} code occurs in the environment of \code{gformula}.
This will typically do the right thing when formulas are created on the fly, but might not
be the right thing if formulas created in one environment are used to create plots
in another.
}
\examples{
gf_linerange()

if (require(mosaicData)) {
gf_ribbon(low_temp + high_temp ~ date, data = Weather,
          fill = ~ city, alpha = 0.4) \%>\%
   gf_theme(theme = theme_minimal())
gf_linerange(
  low_temp + high_temp ~ date | city ~ ., data = Weather,
  color = ~ ((low_temp + high_temp) / 2) ) \%>\%
  gf_refine(scale_colour_gradientn(colors = rev(rainbow(5)))) \%>\%
  gf_labs(color = "mid-temp")

gf_ribbon(low_temp + high_temp ~ date | city ~ ., data = Weather)

# Chaining in the data
Weather \%>\%
  gf_ribbon(low_temp + high_temp ~ date, alpha = 0.4) \%>\%
  gf_facet_grid(city ~ .)
}

if (require(mosaicData) && require(dplyr)) {
HELP2 <- HELPrct \%>\%
  group_by(substance, sex) \%>\%
  summarise(
    mean.age = mean(age),
    median.age = median(age),
    max.age = max(age),
    min.age = min(age),
    sd.age = sd(age),
    lo = mean.age - sd.age,
    hi = mean.age + sd.age
    )

  gf_jitter(age ~ substance, data = HELPrct,
      alpha = 0.5, width = 0.2, height = 0, color = "skyblue") \%>\%
    gf_pointrange( mean.age + lo + hi ~ substance,  data = HELP2) \%>\%
    gf_facet_grid( ~ sex)
  gf_jitter(age ~ substance, data = HELPrct,
      alpha = 0.5, width = 0.2, height = 0, color = "skyblue") \%>\%
    gf_errorbar( lo + hi ~ substance,  data = HELP2) \%>\%
    gf_facet_grid( ~ sex)
 # width is defined differently for gf_boxplot() and gf_jitter()
 #   * for gf_boxplot() it is the full width of the box.
 #   * for gf_jitter() it is half that -- the maximum amount added or subtracted.
 gf_boxplot(age ~ substance, data = HELPrct, width = 0.4) \%>\%
   gf_jitter(width = 0.4, height = 0, color = "skyblue", alpha = 0.5)
 gf_boxplot(age ~ substance, data = HELPrct, width = 0.4) \%>\%
   gf_jitter(width = 0.2, height = 0, color = "skyblue", alpha = 0.5)
}
}
\seealso{
\code{\link[ggplot2:geom_linerange]{ggplot2::geom_linerange()}}

\code{\link[ggplot2:geom_pointrange]{ggplot2::geom_pointrange()}}
}
