% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gf_aux.R
\name{gf_facet_wrap}
\alias{gf_facet_wrap}
\alias{gf_facet_grid}
\title{Add facets to a plot}
\usage{
gf_facet_wrap(object, ...)

gf_facet_grid(object, ...)
}
\arguments{
\item{object}{A ggplot object}

\item{...}{Additional arguments passed to \code{\link[=facet_wrap]{facet_wrap()}} or \code{\link[=facet_grid]{facet_grid()}}.
This typically includes an unnamed formula argument describing the facets.
\code{scales} and \code{space} are additional useful arguments.  See the examples.}
}
\description{
These functions provide more control over faceting than is possible using
the formula interface.
}
\examples{
gf_histogram(~avg_drinks, data = mosaicData::HELPrct) \%>\%
  gf_facet_grid(~substance)
gf_histogram(~avg_drinks, data = mosaicData::HELPrct) \%>\%
  gf_facet_grid(~substance, scales = "free")
gf_histogram(~avg_drinks, data = mosaicData::HELPrct) \%>\%
  gf_facet_grid(~substance, scales = "free", space = "free")
gf_line(births ~ date, data = mosaicData::Births, color = ~wday) \%>\%
  gf_facet_wrap(~year, scales = "free_x", nrow = 5) \%>\%
  gf_theme(
    axis.title.x = element_blank(),
    axis.text.x = element_blank(), axis.ticks.x = element_blank()
  ) \%>\%
  gf_labs(color = "Day")
}
\seealso{
\code{\link[ggplot2:facet_grid]{ggplot2::facet_grid()}}, \code{\link[ggplot2:facet_wrap]{ggplot2::facet_wrap()}}.
}
