% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guide_stringlegend.R
\name{guide_stringlegend}
\alias{guide_stringlegend}
\title{String legend}
\usage{
guide_stringlegend(
  title = waiver(),
  theme = NULL,
  position = NULL,
  direction = NULL,
  nrow = NULL,
  ncol = NULL,
  reverse = FALSE,
  order = 0
)
}
\arguments{
\item{title}{A character string or expression indicating a title of guide.
If \code{NULL}, the title is not shown. By default
(\code{\link[ggplot2:waiver]{waiver()}}), the name of the scale object or the name
specified in \code{\link[ggplot2:labs]{labs()}} is used for the title.}

\item{theme}{A \code{\link[ggplot2:theme]{theme}} object to style the guide individually or
differently from the plot's theme settings. The \code{theme} argument in the
guide overrides, and is combined with, the plot's theme.}

\item{position}{A character string indicating where the legend should be
placed relative to the plot panels.}

\item{direction}{A character string indicating the direction of the guide.
One of "horizontal" or "vertical."}

\item{nrow, ncol}{The desired number of rows and column of legends
respectively.}

\item{reverse}{logical. If \code{TRUE} the order of legends is reversed.}

\item{order}{positive integer less than 99 that specifies the order of
this guide among multiple guides. This controls the order in which
multiple guides are displayed, not the contents of the guide itself.
If 0 (default), the order is determined by a secret algorithm.}
}
\value{
A \code{GuideStringlegend} object.
}
\description{
This type of legend shows colour and fill mappings as coloured text. It does
not draw keys as \code{guide_legend()} does.
}
\examples{
p <- ggplot(mpg, aes(displ, hwy)) +
  geom_point(aes(colour = manufacturer))

# String legend can be set in the `guides()` function
p + guides(colour = guide_stringlegend(ncol = 2))

# The string legend can also be set as argument to the scale
p + scale_colour_viridis_d(guide = "stringlegend")
}
